package com.bcxin.ars.service.datasync;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.datasync.DataSyncDto;
import com.bcxin.ars.dto.page.DataSyncLogPageSearchDto;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 数据同步记录Service接口
 * 
 * @author lin
 * @date 2020-12-07
 */
public interface DataSyncLogService{
    /****
     * 删除
     * @param dataSyncLog
     * @return
     */
    int delete(DataSyncLog dataSyncLog);

    /****
     * 保存
     * @param dataSyncLog
     * @return
     */
    int save(DataSyncLog dataSyncLog);

    /****
     * 选择性修改
     * @param dataSyncLog
     * @return
     */
    void updateSelective(DataSyncLog dataSyncLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
    DataSyncLog findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(DataSyncLogPageSearchDto searchDto, AjaxPageResponse<DataSyncLog> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<DataSyncLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<DataSyncLog> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<DataSyncLog> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<DataSyncLog> findByBatchId(List<DataSyncLog> list);


    /**
     *
     * @param dataSyncLog
     */
    void callback(DataSyncLog dataSyncLog);

    void receive(DataSyncDto dataSyncDto) throws Exception;
}
