package com.bcxin.ars.service.conference;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.UserDto;
import com.bcxin.ars.dto.UserSearchDto;
import com.bcxin.ars.dto.conference.CloudConferenceRoomSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

/**
 * @author zhangyutong
 */
public interface CloudConferenceRoomService {
    /**
     * 查询所有云会议
     * @param cloudConferenceRoomSearchDto 参数
     * @return 列表
     */
    AjaxPageResponse<CloudConferenceRoomSearchDto> listCloudConferenceRoom(CloudConferenceRoomSearchDto cloudConferenceRoomSearchDto);

    /**
     * 云会议室回收
     * @param ids 云会议id
     * @param memberId 用户id
     * @return 成功信息
     */
    AjaxResult recycleVmr(String[] ids, String memberId);

    /**
     * 云会议室分配
     * @param ids 云会议id
     * @param memberId 用户id
     * @return 成功信息
     */
    AjaxResult assignVmr(String[] ids, String memberId);

    /**
     * 获取可分配列表
     * @param userSearchDto user
     * @param userDtoAjaxPageResponse 分页
     * @return user列表
     */
    AjaxPageResponse<UserDto> getAssignList(UserSearchDto userSearchDto,
                                            AjaxPageResponse<UserDto> userDtoAjaxPageResponse);
}
