package com.bcxin.ars.service.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.TrainCertificateSnapshot;
import java.util.List;

/**
 * 培训单位快照保存表Service接口
 *
 * @author yyx
 * @Date 2020-04-24 16:23:31
 */
public interface TrainCertificateSnapshotService {



    /****
     * 保存
     * @param trainCertificateSnapshot
     * @return
     */
    int save(TrainCertificateSnapshot trainCertificateSnapshot);


    /****
     * 主键查询
     * @param qrCodeId
     * @return
     */
    TrainCertificateSnapshot findByQrCodeId(Long qrCodeId);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<TrainCertificateSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<TrainCertificateSnapshot> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<TrainCertificateSnapshot> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<TrainCertificateSnapshot> findByBatchId(List<TrainCertificateSnapshot> list);
}
