package com.bcxin.ars.service.certificate;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.ComCertificateSnapshot;
import java.util.List;

/**
 * 保安服务公司快照保存Service接口
 *
 * @author yyx
 * @Date 2020-04-24 16:23:31
 */
public interface ComCertificateSnapshotService {



    /****
     * 保存
     * @param comCertificateSnapshot
     * @return
     */
    int save(ComCertificateSnapshot comCertificateSnapshot);


    /****
     * 主键查询
     * @param qrCodeId
     * @return
     */
    ComCertificateSnapshot findByQrCodeId(Long qrCodeId);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComCertificateSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComCertificateSnapshot> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<ComCertificateSnapshot> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComCertificateSnapshot> findByBatchId(List<ComCertificateSnapshot> list);
}
