package com.bcxin.ars.service.approve;

import com.bcxin.ars.dto.approve.ApproveTempDto;
import com.bcxin.ars.model.approve.ApproveTemp;

import java.util.List;

/**
 * @author：wangcy @date：2018/01/16 0016 19:44
 * @description：审批模板service
 */
public interface ApproveTempService {
	/**
	 * 获取市级模板数据
	 * 
	 * @return
	 */
	List<ApproveTempDto> findDto();

	/**
	 * @Author: wangcy
	 * @Description:获取模板
	 * @Date: 2018/01/19 0019 10:53
	 */
	ApproveTemp findById(Long id);

	/**
	 * @Author: wangcy
	 * @Description:修改模板信息
	 * @Date: 2018/01/19 0019 10:53
	 */
	void update(ApproveTemp approveTemp);

	/**
	 * @Author: zhangye
	 * @Description:获取用户模板配置状态
	 * @Date: 2018/4/17
	 */
	String getConfigState();

	List<ApproveTemp> findByParentTempId(ApproveTemp approveTemp);

	List<ApproveTemp> findApproveOrgListSj(ApproveTemp approveTemp);

	/**
	 * 判断审批模板当前机构的上级机构是否都配置完成
	 * 
	 * @param approveTemp
	 * @return
	 */
	boolean checkTempConfigComplete(ApproveTemp approveTemp);

    ApproveTemp findByTempCode(String tempCode);

	String getMaxApproveLevel(String tempCode);
}
