package com.bcxin.ars.service.approve;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.approve.ApproveTempLink;
import com.bcxin.ars.model.approve.ApproveTempLinkRela;

import java.util.List;

public interface ApproveTempLinkService {

	void save(Long linkId, Long tempId);

	void delete(Long tempLinkId);

	void update(ApproveTempLink approveTempLink);

	ApproveTempLink findById(Long Id);

	List<ApproveTempLink> findByTempId(Long tempId);

	List<ApproveTempLink> findByLinkId(Long linkId);

	List<ApproveTempLink> findByMtSeq(Long seq, Long tempId);

	// ApproveTempLink findByTempAndLink(Long tempId, Long linkId);

	/**
	 * @Author: wangcy
	 * @Description:批量插入临时表数据
	 * @Date: 2018/01/19 0019 15:31
	 */
	void insertBatchTemp(List<ApproveTempLinkRela> approveList);

	List<ApproveTempLinkRela> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	ApproveTempLink findByMtSeqUp(Long seq, Long tempId);

	ApproveTempLink findByMtSeqDown(Long seq, Long tempId);

	/**
	 * 环节上移
	 * 
	 * @param idArray
	 */
	void updateOrderUp(Long[] idArray);

	/**
	 * 环节下移
	 * 
	 * @param idArray
	 */
	void updateOrderDown(Long[] idArray);

	void updateFlagForOutToIn(List<ApproveTempLinkRela> linkRelaList);
}
