package com.bcxin.ars.service.approve;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.ApproveLinkLevelDto;
import com.bcxin.ars.model.approve.ApproveAreaProcess;
import com.bcxin.ars.model.approve.ApproveLinkLevel;

import java.util.List;

/**
 * @author：wangcy
 * @date：2018/01/19 0019 14:54
 * @description：审批环节层级erservice
 */
public interface ApproveLinkLevelService {

    /**
     * @Author: wangcy
     * @Description:查询属于这个环节的层级
     * @Date: 2018/01/19 0019 15:31
     */
    List<ApproveLinkLevel> findByTempLinkRelaId(Long tempLinkRelaId);

    /**
    * @Author: wangcy
    * @Description:删除环节的层级
    * @Date: 2018/01/19 0019 15:54
    */
    void delete(ApproveLinkLevel approveLinkLevel);
    /**
     * @Author: wangcy
     * @Description:修改或者新增环节的层级(暂存)
     * @Date: 2018/01/19 0019 15:54
     */
    void saveOrUpdate(ApproveLinkLevelDto approveLinkLevelDto);
    /**
     * @Author: wangcy
     * @Description:根据ID查询
     * @Date: 2018/01/19 0019 15:54
     */
    ApproveLinkLevel findById(Long approveLinkLevelId);

    /**
     * @Author: wangcy
     * @Description:查询属于这个环节指定的层级（List）启动的
     * @Date: 2018/01/19 0019 15:31
     */
    List<ApproveLinkLevel> findListTureByApproveLinkIdAndLevel(Long tempLinkRelaId,String approveLevel);

	/**
     * @Author: wangcy
     * @Description:批量插入临时表数据
     * @Date: 2018/01/19 0019 15:31
     */
	void insertBatchTemp(List<ApproveLinkLevel> approveList);

    List<ApproveLinkLevel> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    void updateFlagForOutToIn(List<ApproveLinkLevel> linkLevelList);
}
