package com.bcxin.ars.service;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ThirdTrainBackgroundPageSearchDto;
import com.bcxin.ars.model.ThirdTrainBackground;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 第三方背景筛查Service接口
 *
 * @author lin
 * @date 2021-04-26
 */
public interface ThirdTrainBackgroundService {
    /****
     * 删除
     * @param thirdTrainBackground
     * @return
     */
    int delete(ThirdTrainBackground thirdTrainBackground);

    /****
     * 保存
     * @param thirdTrainBackground
     * @return
     */
    int save(ThirdTrainBackground thirdTrainBackground);

    /****
     * 选择性修改
     * @param thirdTrainBackground
     * @return
     */
    void updateSelective(ThirdTrainBackground thirdTrainBackground);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ThirdTrainBackground findById(Long id);

    /**
     * 分页查询
     *
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(ThirdTrainBackgroundPageSearchDto searchDto, AjaxPageResponse<ThirdTrainBackground> page);

    /**
     * 外导内查询
     *
     * @param searchDto
     * @return
     */
    List<ThirdTrainBackground> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     *
     * @param startDate
     * @return
     */
    List<ThirdTrainBackground> findDSOutList(String startDate);

    /**
     * 批量保存
     *
     * @param list
     */
    void importBatch(List<ThirdTrainBackground> list);

    /**
     * 批量查询
     *
     * @param list
     * @return
     */
    List<ThirdTrainBackground> findByBatchId(List<ThirdTrainBackground> list);

    /**
     * 提交
     *
     * @param thirdTrainBackgrounds
     * @return
     */
    AjaxResult commitPeopleBackgroundScreening(String thirdTrainBackgrounds);

    /**
     * 查询背景筛查情况
     *
     * @param thirdTrainBackground
     * @return
     */
    AjaxResult listPeopleBackgroundScreening(String thirdTrainBackground);
}
