package com.bcxin.ars.service;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryManagerSearchDto;
import com.bcxin.ars.model.SbSubsidiaryManager;

import java.util.List;

/**
 * 子公司管理类
 * @author Ethan
 */
public interface SbSubsidiaryManagerService {


	/**
	 * 新增或更新子公司管理信息
	 * @param sbSubsidiaryManager
	 */
	void saveOrUpdate(SbSubsidiaryManager sbSubsidiaryManager);

	/**
	 * 根据ID获取子公司管理信息
	 * @param id
	 * @return
	 */
	public SbSubsidiaryManager findById(long id);

	/**
	 * 删除子公司管理信息
	 * @param sbSubsidiaryManager
	 * @return
	 */
	void delete(SbSubsidiaryManager sbSubsidiaryManager);


	/**
	 * 查询子公司管理信息
	 * @param dto
	 * @return
	 */
	public SbSubsidiaryManagerSearchDto search(SbSubsidiaryManagerSearchDto dto);

	List<SbSubsidiaryManager> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(SbSubsidiaryManager sbSubsidiaryManager);


}
