package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.Role;

/**
 * 角色服务类
 * @author Ethan
 */
public interface RoleService {

	List<Role> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	/**
	 * 新增或更新角色
	 * @param org
	 */
	void saveOrUpdate(Role role);
	
	/**
	 * 删除角色
	 * @param org
	 */
	void delete(Role role);
	
	/**
	 * 根据ID获得角色
	 * @param id
	 * @return
	 */
	Role findById(Long id);
	
	/**
	 * 根据公司获取角色
	 * @param parentId
	 * @return
	 */
	List<Role> findByCompany(Long companyId);

	void saveOrUpdateForDS(Role role);

	List<Role> findByUserId(Long userId);

	List<Role> findByUserIdCompanyId(Long userId, Long companyId);

	/****
	 * 根据公司ID查询角色全部
	 * @param companyId 公司ID
	 * @return 角色列表
	 */
	List<Role> findByCompanyAll(Long companyId);
}
