package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.OrganizationSAASDTO;
import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.OrganizationDto;
import com.bcxin.ars.model.SecurityCompany;

/**
 * 组织架构服务类
 * @author Ethan
 */
public interface OrganizationService {

	List<Organization> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	/**
	 * 新增或更新组织架构
	 * @param org
	 */
	void saveOrUpdate(Organization org);

	/**
	 * 批量新增或更新组织架构
	 * @param organizationSAASDTOList
	 * @param company
	 */
	void saveOrUpdateBatch(List<OrganizationSAASDTO> organizationSAASDTOList, SecurityCompany company);
	
	/**
	 * 删除组织架构
	 * @param org
	 */
	void delete(Organization org);
	
	/**
	 * 根据用户ID获得组织架构
	 * @param id
	 * @return
	 */
	Organization findById(long id);
	
	/**
	 * 根据父Id获取组织架构列表
	 * @param parentId
	 * @return
	 */
	List<Organization> findByParentId(long parentId);
	
	/**
	 * 根据公司获取组织架构列表
	 * @param companyId
	 * @return
	 */
	List<Organization> findByCompany(long companyId);
	/****
	 * 查询某个组织机构的保安人员人数
	 * @param organization
	 * @return
	 */
	Long queryCount(Organization organization);
	void saveOrUpdateForDS(Organization organization);

	/***
	 * 通过单位ID查出所有部门信息
	 * @param companyId
	 * @return
	 * by llc 2018-08-29
	 */
	List<OrganizationDto> findOrgInfoByCompanyId(long companyId);

	/***
	 * 通过单位ID或者上级id查出所有部门信息
	 * @param orgDto
	 * @return
	 * by llc 2018-08-29
	 */
    List<OrganizationDto> findByParentIdAndCompanyId(OrganizationDto orgDto);
}
