package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.OrderPersonSearchDto;
import com.bcxin.ars.dto.sb.OrderSearchDto;
import com.bcxin.ars.model.OrderPerson;

/**
 * 订单与保安人员关系服务类
 * @author Ethan
 */
public interface OrderPersonService {
	
	void save(OrderPerson orderPerson);

	public OrderPerson findById(Long id);

	List<OrderPerson> findListByOrderId(Long orderId);

	OrderPersonSearchDto findByOrderid(OrderPersonSearchDto dto);

	void updateTrainInfo(OrderPerson orderPerson);

	List<OrderPerson> findAll();

	List<OrderPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(OrderPerson orderPerson);
}