package com.bcxin.ars.service;
import com.bcxin.ars.dto.sb.FilerecordStatusSearchDto;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.model.FilerecordStatus;

import java.util.List;

/**
 * 文件记录信息
 * @author Ethan
 */
public interface FilerecordStatusService {


	/**
	 * 新增或更新文件记录信息
	 * @param filerecordStatus
	 */
	void saveOrUpdate(FilerecordStatus filerecordStatus);

	/**
	 * 根据ID获取文件记录信息
	 * @param id
	 * @return
	 */
	public FilerecordStatus findById(long id);



	void save(FilerecordStatus filerecordStatus);




	/**
	 *
	 * @Decription:批量查询ID是否有在列表中
	 * @author：wjb
	 * @method  findByBatchId
	 * @date：2018年9月14日10:28:57
	 * @params： * @param filerecordStatusList
	 * @return@return java.util.List<com.bcxin.ars.model.FilerecordStatus>
	 */
	List<FilerecordStatus> findFilerecordStatusByTime(List<FilerecordStatus> filerecordStatusList,String startDate, String endDate);

	/**
	 *
	 * @Decription:批量插入同步文件记录
	 * @author：wjb
	 * @method  importBatchFilerecordStatus
	 * @date：2018年9月14日10:11:45
	 * @params： * @param filerecordStatusList
	 * @param filerecordList
	 */
	void importBatchFilerecordStatus(List<Filerecord> filerecordList);

	/**
	 * 查询
	 * @param filerecordStatus
	 * @return FilerecordStatusSearchDto
	 */
	FilerecordStatusSearchDto search(FilerecordStatusSearchDto filerecordStatus);
}
