package com.bcxin.ars.service;

import com.bcxin.ars.dto.sb.CyCheckSearchDto;
import com.bcxin.ars.model.CyCheck;

import java.util.List;

/**
 * 监督检查情况
 *
 * @author Ethan
 */
public interface CyCheckService {


    /**
     * 新增或更新监督检查情况信息
     *
     * @param cyCheck
     */
    void saveOrUpdate(CyCheck cyCheck);

    /**
     * 根据ID获取监督检查情况
     *
     * @param id
     * @return
     */
    public CyCheck findById(long id);

    /**
     * 删除保安监督检查情况
     *
     * @param cyCheck
     * @return
     */
    void delete(CyCheck cyCheck);

    /**
     * 获取统计条数
     */

    long count(CyCheckSearchDto dto);

    /**
     * 查询监督检查情况
     *
     * @param dto
     * @return
     */
    public CyCheckSearchDto search(CyCheckSearchDto dto);

    /**
     * 批量导出监督检查情况信息数据
     *
     * @param dto
     * @return
     */
    List<CyCheck> searchForExportData(CyCheckSearchDto dto);

    /**
     * 批量导入监督检查情况信息(数据库导入）
     *
     * @param cyCheck
     */
    void saveOrUpdateForDS(CyCheck cyCheck);
}
