#消息通知
CREATE TABLE `newsnotice_police` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(50) DEFAULT NULL,
  `newsTitle` varchar(10) DEFAULT NULL COMMENT '标题',
  `newsContext` longtext DEFAULT NULL COMMENT '消息内容',
  `sendId` int(11) DEFAULT NULL COMMENT '发送人ID',
  `sendName` varchar(50) DEFAULT NULL COMMENT '发送人员姓名',
  `sendOrgName` varchar(200) DEFAULT NULL COMMENT '发送机构名称',
  `sendOrgId` int(11) DEFAULT NULL COMMENT '发送机构ID',
  `undoState` varchar(3) DEFAULT NULL COMMENT '是否撤消 0未撤消1已撤消',
  `readnum` Int(11) DEFAULT NULL COMMENT '已读数',
  `unreadnum` Int(11) DEFAULT NULL COMMENT '未读数',
  `temporaryState` varchar(3) DEFAULT NULL COMMENT '暂存状态 0暂存1保存',
  `noticeperson` varchar(3) DEFAULT NULL COMMENT '是否通知保安人员 0不通知1通知',
  `areaCode` varchar(10) DEFAULT NULL COMMENT '发送人机构编码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=358 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#系统附件信息表
CREATE TABLE `sys_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(50) DEFAULT NULL,
  `path` varchar(200) DEFAULT NULL COMMENT '附件地址',
  `businessid` Int(11) DEFAULT NULL COMMENT '业务ID',
  `businesstype` varchar(3) DEFAULT NULL COMMENT '业务类型 001公安消息附件',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=358 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

#公司与消息通知
CREATE TABLE `news_company_relationship` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` bit(1) DEFAULT NULL COMMENT '是否可用',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `update_by` varchar(50) DEFAULT NULL,
  `path` varchar(200) DEFAULT NULL COMMENT '附件地址',
  `companyId` Int(11) DEFAULT NULL COMMENT '公司ID',
  `newsnoticeId` Int(11) DEFAULT NULL COMMENT '公安消息ID',
  `comanyName` varchar(200) DEFAULT NULL COMMENT '公司名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=358 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;