/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util.huawei;

import com.bcxin.ars.util.huawei.CheckPathUtil;
import com.bcxin.ars.util.huawei.HttpUtil;
import com.bcxin.ars.util.huawei.RestRequest;
import com.bcxin.ars.util.huawei.RestResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpBuildUtil.class);
    private static String url = "https://api.meeting.huaweicloud.com";
    private static String schema = CheckPathUtil.getSchemeFromHttpAddress(url);
    private static String ip = CheckPathUtil.getIpFromHttpAddress(url);
    private static int port = CheckPathUtil.getPortFromHttpAddress(url);

    public static HttpHost getHttpHost() {
        HttpHost httpHost = new HttpHost(ip, port, schema);
        return httpHost;
    }

    public static RestRequest buildRestRequest(String method, Map<String, String> headers, String entity, Map<String, String> params) {
        RestRequest restRequest = new RestRequest();
        headers.put("Content-Type", "application/json");
        restRequest.setHttpHeaders(headers);
        restRequest.setHttpMethod(method);
        if (entity != null) {
            restRequest.setEntity(entity);
        }
        if (params != null) {
            restRequest.setParameters(params);
        }
        log.info("restRequest is: " + restRequest.toString());
        return restRequest;
    }

    public static RestResponse sendMsg(String resourceUri, RestRequest restRequest) {
        log.info("enter sendMsg");
        HttpHost host = HttpBuildUtil.getHttpHost();
        RestResponse response = null;
        try {
            response = HttpUtil.getInstance().sendMessage(host, resourceUri, restRequest);
            log.info("response is: " + response.toString());
        }
        catch (URISyntaxException e) {
            log.error("send msg uri syntax error:" + e.getMessage());
        }
        catch (IOException e) {
            log.error("send msg io error:" + e.getMessage());
        }
        log.info("out sendMsg");
        return response;
    }
}

