/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.bcxin.ars.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;

public class IdcardValidator {
    protected String[][] codeAndCity = new String[][]{{"11", "\u5317\u4eac"}, {"12", "\u5929\u6d25"}, {"13", "\u6cb3\u5317"}, {"14", "\u5c71\u897f"}, {"15", "\u5185\u8499\u53e4"}, {"21", "\u8fbd\u5b81"}, {"22", "\u5409\u6797"}, {"23", "\u9ed1\u9f99\u6c5f"}, {"31", "\u4e0a\u6d77"}, {"32", "\u6c5f\u82cf"}, {"33", "\u6d59\u6c5f"}, {"34", "\u5b89\u5fbd"}, {"35", "\u798f\u5efa"}, {"36", "\u6c5f\u897f"}, {"37", "\u5c71\u4e1c"}, {"41", "\u6cb3\u5357"}, {"42", "\u6e56\u5317"}, {"43", "\u6e56\u5357"}, {"44", "\u5e7f\u4e1c"}, {"45", "\u5e7f\u897f"}, {"46", "\u6d77\u5357"}, {"50", "\u91cd\u5e86"}, {"51", "\u56db\u5ddd"}, {"52", "\u8d35\u5dde"}, {"53", "\u4e91\u5357"}, {"54", "\u897f\u85cf"}, {"61", "\u9655\u897f"}, {"62", "\u7518\u8083"}, {"63", "\u9752\u6d77"}, {"64", "\u5b81\u590f"}, {"65", "\u65b0\u7586"}, {"71", "\u53f0\u6e7e"}, {"81", "\u9999\u6e2f"}, {"82", "\u6fb3\u95e8"}, {"91", "\u56fd\u5916"}};
    private String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private String[] verifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static final int invalidAge = -1;

    public boolean isValidatedAllIdcard(String idcard) {
        if (idcard.length() == 15) {
            idcard = this.convertIdcarBy15bit(idcard);
        }
        return this.isValidate18Idcard(idcard);
    }

    public static int getAgeByIDNumber(String idNumber) {
        String dateStr;
        if (idNumber.length() == 15) {
            dateStr = "19" + idNumber.substring(6, 12);
        } else if (idNumber.length() == 18) {
            dateStr = idNumber.substring(6, 14);
        } else {
            return -1;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            Date birthday = simpleDateFormat.parse(dateStr);
            return IdcardValidator.getAgeByDate(birthday);
        }
        catch (ParseException e) {
            return -1;
        }
    }

    public static int getAgeByDateString(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date birthday = simpleDateFormat.parse(dateStr);
            return IdcardValidator.getAgeByDate(birthday);
        }
        catch (ParseException e) {
            return -1;
        }
    }

    public static int getAgeByDate(Date birthday) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.getTimeInMillis() - birthday.getTime() < 0L) {
            return -1;
        }
        int yearNow = calendar.get(1);
        int monthNow = calendar.get(2);
        int dayOfMonthNow = calendar.get(5);
        calendar.setTime(birthday);
        int yearBirthday = calendar.get(1);
        int monthBirthday = calendar.get(2);
        int dayOfMonthBirthday = calendar.get(5);
        int age = yearNow - yearBirthday;
        if (monthNow <= monthBirthday && monthNow == monthBirthday && dayOfMonthNow < dayOfMonthBirthday || monthNow < monthBirthday) {
            --age;
        }
        return age;
    }

    public static void main(String[] args) {
        IdcardValidator idcardValidator = new IdcardValidator();
        System.out.println(idcardValidator.isValidatedAllIdcard("610121196606014437"));
    }

    public boolean isValidate18Idcard(String idcard) {
        if (idcard.length() != 18) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        String idcard18Code = idcard.substring(17, 18);
        char[] c = null;
        String checkCode = "";
        if (!this.isDigital(idcard17)) {
            return false;
        }
        c = idcard17.toCharArray();
        String strYear = idcard.substring(6, 10);
        String strMonth = idcard.substring(10, 12);
        String strDay = idcard.substring(12, 14);
        return DateUtil.checkDate(strYear + "-" + strMonth + "-" + strDay);
    }

    public boolean isValidate15Idcard(String idcard) {
        if (idcard.length() != 15) {
            return false;
        }
        if (this.isDigital(idcard)) {
            String provinceid = idcard.substring(0, 2);
            String birthday = idcard.substring(6, 12);
            int year = Integer.parseInt(idcard.substring(6, 8));
            int month = Integer.parseInt(idcard.substring(8, 10));
            int day = Integer.parseInt(idcard.substring(10, 12));
            boolean flag = false;
            for (String id : this.cityCode) {
                if (!id.equals(provinceid)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
            Date birthdate = null;
            try {
                birthdate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (birthdate == null || new Date().before(birthdate)) {
                return false;
            }
            GregorianCalendar curDay = new GregorianCalendar();
            int curYear = curDay.get(1);
            int year2bit = Integer.parseInt(String.valueOf(curYear).substring(2));
            if (year < 50 && year > year2bit) {
                return false;
            }
            if (month < 1 || month > 12) {
                return false;
            }
            boolean mflag = false;
            curDay.setTime(birthdate);
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    mflag = day >= 1 && day <= 31;
                    break;
                }
                case 2: {
                    if (curDay.isLeapYear(curDay.get(1))) {
                        mflag = day >= 1 && day <= 29;
                        break;
                    }
                    mflag = day >= 1 && day <= 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    boolean bl = mflag = day >= 1 && day <= 30;
                }
            }
            return mflag;
        }
        return false;
    }

    public String convertIdcarBy15bit(String idcard) {
        String idcard17 = null;
        if (idcard.length() != 15) {
            return null;
        }
        if (this.isDigital(idcard)) {
            String birthday = idcard.substring(6, 12);
            Date birthdate = null;
            try {
                birthdate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar cday = Calendar.getInstance();
            cday.setTime(birthdate);
            String year = String.valueOf(cday.get(1));
            idcard17 = idcard.substring(0, 6) + year + idcard.substring(8);
            char[] c = idcard17.toCharArray();
            String checkCode = "";
            if (null != c) {
                int[] bit = new int[idcard17.length()];
                bit = this.converCharToInt(c);
                int sum17 = 0;
                sum17 = this.getPowerSum(bit);
                checkCode = this.getCheckCodeBySum(sum17);
                if (null == checkCode) {
                    return null;
                }
                idcard17 = idcard17 + checkCode;
            }
        } else {
            return null;
        }
        return idcard17;
    }

    public boolean isIdcard(String idcard) {
        return idcard == null || "".equals(idcard) ? false : Pattern.matches("(^\\d{15}$)|(\\d{17}(?:\\d|x|X)$)", idcard);
    }

    public boolean is15Idcard(String idcard) {
        return idcard == null || "".equals(idcard) ? false : Pattern.matches("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$", idcard);
    }

    public boolean is18Idcard(String idcard) {
        return Pattern.matches("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([\\d|x|X]{1})$", idcard);
    }

    public boolean isDigital(String str) {
        return str == null || "".equals(str) ? false : str.matches("^[0-9]*$");
    }

    public int getPowerSum(int[] bit) {
        int sum = 0;
        if (this.power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < this.power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * this.power[j];
            }
        }
        return sum;
    }

    public String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
            }
        }
        return checkCode;
    }

    public int[] converCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }
}

