package com.bcxin.ars.util.gx.encry;

import com.bcxin.ars.util.Constants;

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;


public class SSOAES {

    public static final String ENCRYPT_CHARSET = "UTF-8";

    public SSOAES(){
    }

    /**
     * AES解密示例
     * @param args
     * @throws Exception
     */
    public static void main(String[] args) throws Exception{
        String appKey = Constants.GX_APP_KEY;
        String userData = "3A3AC14F0DA2C50E58097E426BC477ED";
        String value = decrypt(userData, appKey);
        System.out.println(value);
    }

    /**
     * AES加密
     * @param content
     * @param password
     * @return
     */
    public static String encrypt(String content, String password){
        try{
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            secureRandom.setSeed(password.getBytes());
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = content.getBytes("UTF-8");
            cipher.init(1, key);
            byte[] result = cipher.doFinal(byteContent);
            if(result != null && result.length > 0){
                return parseByte2HexStr(result);
            }
        }catch(NoSuchAlgorithmException var10){
            var10.printStackTrace();
        }catch(NoSuchPaddingException var11){
            var11.printStackTrace();
        }catch(InvalidKeyException var12){
            var12.printStackTrace();
        }catch(UnsupportedEncodingException var13){
            var13.printStackTrace();
        }catch(IllegalBlockSizeException var14){
            var14.printStackTrace();
        }catch(BadPaddingException var15){
            var15.printStackTrace();
        }

        return null;
    }

    /**
     * AES解密
     * @param content
     * @param password
     * @return
     * @throws Exception
     */
    public static String decrypt(String content, String password) throws Exception{
        try{
            if(content == null){
                return null;
            }

            byte[] newContent = parseHexStr2Byte(content);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            secureRandom.setSeed(password.getBytes());
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(newContent);
            if(result != null && result.length > 0){
                return new String(result, "UTF-8");
            }
        }catch(NoSuchAlgorithmException var10){
            var10.printStackTrace();
        }catch(NoSuchPaddingException var11){
            var11.printStackTrace();
        }catch(InvalidKeyException var12){
            var12.printStackTrace();
        }catch(IllegalBlockSizeException var13){
            var13.printStackTrace();
        }catch(BadPaddingException var14){
            var14.printStackTrace();
        }

        return null;
    }

    public static String parseByte2HexStr(byte[] buf){
        StringBuffer sb = new StringBuffer();

        for(int i = 0; i < buf.length; ++ i){
            String hex = Integer.toHexString(buf[i] & 255);
            if(hex.length() == 1){
                hex = '0' + hex;
            }

            sb.append(hex.toUpperCase());
        }

        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr){
        if(hexStr.length() < 1){
            return null;
        }else{
            byte[] result = new byte[hexStr.length() / 2];

            for(int i = 0; i < hexStr.length() / 2; ++ i){
                int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
                int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
                result[i] = (byte) (high * 16 + low);
            }
            return result;
        }
    }

}
