package com.bcxin.ars.util;


public class Sha1Util {

	public static final String HASH_ALGORITHM = "SHA-1";
	public static final int HASH_INTERATIONS = 1024;
	public static final int SALT_SIZE = 8;

	/**
	 * 生成安全的密码，生成随机的16位salt并经过1024次 sha-1 hash
	 */

	public static String entryptPassword(String plainPassword) {
		String plain = Encodes.unescapeHtml(plainPassword);
		byte[] salt = Digests.generateSalt(SALT_SIZE);
		byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, HASH_INTERATIONS);
		return Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword);
	}

	/**
	 * 验证密码
	 *
	 * @param plainPassword
	 *            明文密码
	 * @param password
	 *            密文密码
	 * @return 验证成功返回true
	 */

	public static boolean validatePassword(String plainPassword, String password) {
		String plain = Encodes.unescapeHtml(plainPassword);
		byte[] salt = Encodes.decodeHex(password.substring(0, 16));
		byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, HASH_INTERATIONS);
		return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
	}



	public static void main(String[] args) {
		String password ="bcxin20200629";
		System.out.println(Sha1Util.entryptPassword(password));
		String  code="8E95D87C585C581532455DACAA0539C381ACE21258584839AA0FE815602AC1D7EFC72EA830FBD874997A298ED85C49C2B5F6E420EE706071590F40969FAFB839";
		System.out.println("值是否相同"+Sha1Util.validatePassword(password,code)+"--"+code.substring(0, 16));

	}

//    public static void main(String[] args) {
//        String str1 = "abcdefghijklmnabc";
//        // 从头开始查找是否存在指定的字符
//        System.out.println(str1.indexOf("a"));
//        // 从第四个字符位置开始往后继续查找
//        System.out.println(str1.indexOf("c", 3));
//        //若指定字符串中没有该字符则系统返回-1
//        System.out.println(str1.indexOf("x"));
//    }
}
