package com.bcxin.ars.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {

	private static Logger logger = LoggerFactory.getLogger(RestUtil.class);
	
	public static String restful(String url, Map<String, String> data) throws IOException {
		String result = "";
		HttpPost httpPost = new HttpPost(url);
        List<NameValuePair> list = new ArrayList<NameValuePair>();
        if(data != null && data.size() > 0) {
        	Iterator iterator = data.entrySet().iterator();  
            while(iterator.hasNext()){  
                Entry<String,String> elem = (Entry<String, String>) iterator.next();  
                list.add(new BasicNameValuePair(elem.getKey(),elem.getValue()));  
            }  
            if(list.size() > 0){  
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, "UTF-8");  
                httpPost.setEntity(entity);  
            }
        }
		HttpClient client = new DefaultHttpClient();
		HttpResponse response = client.execute(httpPost);
		if(response != null){  
            HttpEntity resEntity = response.getEntity();
            if(resEntity != null){
                result = EntityUtils.toString(resEntity,"UTF-8");  
            }
            if(response.getStatusLine().getStatusCode() == 200) {
            	return result;
            } else {
            	logger.error("url:" + url + ", code:" + response.getStatusLine().getStatusCode() + "," + result);
            }
        } else {
        	logger.error("url:" + url + ", 无返回。");
        }
		return result;
	}
	
	public static String restful(String url) throws IOException {
		return restful(url, null);
	}
	
}
