package com.bcxin.ars.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

/**
 * 根据map里面的字段名称反射复制类
 * Created by wangjianchi on 2017/7/19.
 */
public class EntityForWebServiceUtil {

    /**
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(EntityForWebServiceUtil.class);
    
    
    public static void copy(Map<String, KeyAndDefauleVal> dataMap, Object sourceObj, Object targetObj) throws Exception {
        //数据源Class
        Class sourceClass = sourceObj.getClass();
        //目标Class
        Class targetClass = targetObj.getClass();
        int size = dataMap.size();
        if (dataMap != null && size > 0) {
            Field[] targetFields = targetClass.getDeclaredFields(); // 获取目标实体类的所有属性，返回Field数组
            Field[] sourceFields = sourceClass.getDeclaredFields();// 获取数据源实体类的所有属性，返回Field数组
            for (Map.Entry<String, KeyAndDefauleVal> map : dataMap.entrySet()) {

                for (int k = 0; k < targetFields.length; k++) {
                    Field targetField = targetFields[k];
                    //置些属性是可以访问的
                    targetField.setAccessible(true);
                    //获取数据源属性的名字
                    // logger.info(map.getKey() + "====" + targetField.getName());
                    if (map.getKey().equals(targetField.getName())) { //Map的Key值与数据源的属性值一致表示当前字段属性
                        String sourceProperty = map.getValue().getKey();
                        String targetProperty = targetField.getName();
                        Object sourcePropertyDefaultVal = map.getValue().getDefaultVal();

                        for (int j = 0; j < sourceFields.length; j++) {
                            Field sourceField = sourceFields[j];
                            if (sourceField.getName().equals(sourceProperty)) {
                                targetProperty = getMethodName(targetField.getName());
                                Method setMethod = targetClass.getMethod("set" + targetProperty, targetField.getType());
                                //表示源属性类型和目标属性类型一致
                                if (targetField.getGenericType().toString().equals(sourceField.getGenericType().toString()) && sourcePropertyDefaultVal == null) {
                                    //直接给对应的目标属性赋值
                                    sourceProperty = getMethodName(sourceProperty);
                                    Method getMethod = sourceClass.getMethod("get" + sourceProperty);
                                    Object value = getMethod.invoke(sourceObj);
                                    if (value != null) {
                                        setMethod.invoke(targetObj, value);
                                    }
                                } else {
                                    if (sourcePropertyDefaultVal != "") {
                                        setMethod.invoke(targetObj, sourcePropertyDefaultVal);
                                    }
                                }
                            }
                        }
                    }
                }

            }
        }
    }

    // 把一个字符串的第一个字母大写、效率是最高的、
    private static String getMethodName(String fildeName) throws Exception {
        byte[] items = fildeName.getBytes();
        items[0] = (byte) ((char) items[0] - 'a' + 'A');
        return new String(items);
    }
}
