package com.bcxin.ars.util;

import lombok.extern.slf4j.Slf4j;

import javax.mail.*;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

@Slf4j
public class EmailUtils {

    //发送信件邮箱的用户名及密码
    private static String username;
    private static String password;

    //右键服务器设置
    private static String host;
    private static String from;//发件人

//    private final static ResourceBundle config = ResourceBundle.getBundle("config/config");


    /*
     * 初始化方法
     */
    public EmailUtils() {
//        host = config.getString("mail_host");
//        username = config.getString("mail_from");
//        password = config.getString("mail_password");
//        from = config.getString("mail_from");
//        mail_host=smtp.mxhichina.com
//        mail_from=service@baichuanxin.com
//                mail_password=Aa12345678
        host = "smtp.mxhichina.com";
        username = "service@baichuanxin.com";
        password = "Aa12345678";
        from = "service@baichuanxin.com";
    }

    
    /**
     * 发送邮件
     * 
     * @param subject
     *            邮件主题
     * @param body
     *            邮件内容
     * @param to
     *            收件人地址
     *            附件
     */

    public void sendEmail(String subject, String body, String to) {
        //windows环境先屏蔽掉邮件
        try {
            Properties props = System.getProperties();
            // 创建信件服务器
            props.put("mail.smtp.host", host);
            props.put("mail.smtp.auth", "true");
            props.put("mail.transport.protocol", "smtp");
            // 得到默认的对话对象
            Authenticator a = new Authenticator() {
                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            };
            //创建Session实例
            Session session = Session.getDefaultInstance(props, a);
            //创建MimeMessage实例对象
            MimeMessage msg = new MimeMessage(session);
            //设置发信人
        //		msg.setFrom(new InternetAddress(from));
            //设置自定义发件人昵称
            String nick = "";
            try {
                nick = javax.mail.internet.MimeUtility.encodeText("百川信");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            msg.setFrom(new InternetAddress(nick + " <" + from + ">"));
            //设置收信人
            msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
            //设置发送日期
            msg.setSentDate(new Date());
            //设置邮件主题
            msg.setSubject(subject);
            //设置邮件正文
            // 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
            Multipart multipart = new MimeMultipart();

            // 添加邮件正文
            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(body, "text/html;charset=UTF-8");
            multipart.addBodyPart(contentPart);
            msg.setContent(multipart);
            Transport.send(msg);

            log.debug("邮件发送成功，收件人[{}]，主题[{}]，发送内容[{}]",to,subject,body);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("邮件发送失败，收件人[{}]，主题[{}]，发送内容[{}]",to,subject,body);
            log.error("邮件发送失败，异常[{}]",e.getMessage());
        }
    }

    public static void main(String[] args) {
        EmailUtils emailUtils = new EmailUtils();
        emailUtils.sendEmail(Constants.DATASYNC_SUBJECT,Constants.DATASYNC_SENDHTML_IN2OUT,"linqinglin@bcxin.com.cn");

    }
}
