package com.bcxin.ars.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.util.ftp.FtpUtils;
import com.bcxin.ars.util.message.HttpClientUtil;
import com.google.common.collect.Lists;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/7/9.
 */
public class Base64Img {
	

    /***
     * 图片转成base64位
     * @param path
     * @param baseFolder
     * @return
     */
    public static String encodeBase64File(String path,String baseFolder) {
    	path = path.replace("getResource.do?path=", "");
    	path = baseFolder + path;
    	return GetImageStr(path);
    }

    /***
     * 图片转成base64位
     * @param path
     * @param
     * @return
     */
    public static String encodeBase64FileBJ(String path,String ftpServerTemp) {
        path = path.replace("getResource.do?path=", "");
        String[] paths =  path.split("/");
        //文件路径
        String filePath =  paths[0] + "/" + paths[1];
        //文件名称
        String fileName = paths[2];
        File file = null;
        file = FtpUtils.downloadFile(Constants.BJ_FTPHOST, Constants.BJ_FTPUSERNAME, Constants.BJ_FTPPASSWORD, Constants.BJ_PORT, filePath,ftpServerTemp+DateUtil.systemDate.format(new Date())+"/", fileName);
        //将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        InputStream in = null;
        byte[] data = null;
        //读取图片字节数组
        try
        {
            in = new FileInputStream(file);
            data = new byte[in.available()];
            in.read(data);
            in.close();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        //对字节数组Base64编码
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);//返回Base64编码过的字节数组字符串
    }

    /**
     *2018年8月21日16:59:15 wjb 图片类型
     * @param imgFile
     * @desc 图片转化成base64字符串
     * @return
     */

    public static String GetImageStr(String imgFile,String type){
        //将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        InputStream in = null;
        byte[] data = null;

        //读取图片字节数组
        try
        {
            in = new FileInputStream(imgFile);
            data = new byte[in.available()];
            in.read(data);
            in.close();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        //对字节数组Base64编码
        BASE64Encoder encoder = new BASE64Encoder();
        return "data:image/"+type+";base64,"+encoder.encode(data);//返回Base64编码过的字节数组字符串
    }

    //图片转化成base64字符串
    public static String GetImageStr(String imgFile){
        //将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        InputStream in = null;
        byte[] data = null;
        //读取图片字节数组
        try
        {
            in = new FileInputStream(imgFile);
            data = new byte[in.available()];
            in.read(data);
            in.close();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        //对字节数组Base64编码
        BASE64Encoder encoder = new BASE64Encoder();

            return encoder.encode(data);//返回Base64编码过的字节数组字符串


    }
    //base64字符串转化成图片
    public static boolean GenerateImage(String imgStr){
        //对字节数组字符串进行Base64解码并生成图片
        if (imgStr == null) //图像数据为空
            return false;
        BASE64Decoder decoder = new BASE64Decoder();
        try
        {
            //Base64解码
            byte[] b = decoder.decodeBuffer(imgStr);
            for(int i=0;i<b.length;++i)
            {
                if(b[i]<0)
                {//调整异常数据
                    b[i]+=256;
                }
            }
            //生成jpeg图片
            String imgFilePath = "d://222.jpg";//新生成的图片
            OutputStream out = new FileOutputStream(imgFilePath);
            out.write(b);
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e)
        {
            return false;
        }
    }

    private String url = "http://120.76.218.179:9141/authentication/";
    private String charset = "utf-8";
    private HttpClientUtil httpClientUtil = null;



    public void test(){
        httpClientUtil = new HttpClientUtil();
        String httpOrgCreateTest = url + "identityauth";
        Map<String,String> createMap = new HashMap<String,String>();
        createMap.put("name","苏炳辉");
        createMap.put("idNumber","35060019880520203X");
        createMap.put("imgbase64",Base64Img.GetImageStr("d:/test.jpg"));
        String httpOrgCreateTestRtn = httpClientUtil.doPost(httpOrgCreateTest,createMap,charset);
        System.out.println("result:"+httpOrgCreateTestRtn);
    }

}
