/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util.spring.util;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public final class SpringUtils
implements ApplicationContextAware,
BeanFactoryPostProcessor {
    private static ConfigurableListableBeanFactory beanFactory;
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtils.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SpringUtils.beanFactory = beanFactory;
    }

    public static <T> T getBean(String name) throws BeansException {
        return (T)beanFactory.getBean(name);
    }

    public static <T> T getBean(Class<T> clz) throws BeansException {
        Object result = beanFactory.getBean(clz);
        return (T)result;
    }

    public static boolean containsBean(String name) {
        return beanFactory.containsBean(name);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.isSingleton(name);
    }

    public static Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.getType(name);
    }

    public static String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.getAliases(name);
    }

    public static List<Map.Entry<String, Object>> getDataSyncBeanList_sync(final Class clazz) {
        Map<String, Object> beans = SpringUtils.getBeansByAnnotation(clazz);
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(beans.entrySet());
        List<Map.Entry<String, Object>> maps = list.stream().filter(map -> SyncType.ASYNC.equals((Object)SpringUtils.getSyncType(map.getValue(), clazz))).collect(Collectors.toList());
        Collections.sort(maps, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> map1, Map.Entry<String, Object> map2) {
                Object o1 = map1.getValue();
                Object o2 = map2.getValue();
                return SpringUtils.getDataSyncSeq(map1.getValue(), clazz) - SpringUtils.getDataSyncSeq(map2.getValue(), clazz);
            }
        });
        return maps;
    }

    public static List<Map.Entry<String, Object>> getDataSyncBeanList_assync(final Class clazz) {
        Map<String, Object> beans = SpringUtils.getBeansByAnnotation(clazz);
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(beans.entrySet());
        List<Map.Entry<String, Object>> maps = list.stream().filter(map -> SyncType.SYNC.equals((Object)SpringUtils.getSyncType(map.getValue(), clazz))).collect(Collectors.toList());
        Collections.sort(maps, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> map1, Map.Entry<String, Object> map2) {
                Object o1 = map1.getValue();
                Object o2 = map2.getValue();
                return SpringUtils.getDataSyncSeq(map1.getValue(), clazz) - SpringUtils.getDataSyncSeq(map2.getValue(), clazz);
            }
        });
        return maps;
    }

    public static int getDataSyncSeq(Object entityService, Class clazz) {
        Class<?> entityServiceClazz = entityService.getClass();
        Object annotation = entityServiceClazz.getAnnotation(clazz);
        if (annotation instanceof DataSyncAnnotation) {
            DataSyncAnnotation dataSyncAnnotation = (DataSyncAnnotation)annotation;
            return dataSyncAnnotation.getSeq();
        }
        if (annotation instanceof DataSyncOutAnnotation) {
            DataSyncOutAnnotation dataSyncAnnotation = (DataSyncOutAnnotation)annotation;
            return dataSyncAnnotation.getSeq();
        }
        return 0;
    }

    public static SyncType getSyncType(Object entityService, Class clazz) {
        Class<?> entityServiceClazz = entityService.getClass();
        Object annotation = entityServiceClazz.getAnnotation(clazz);
        if (annotation instanceof DataSyncAnnotation) {
            DataSyncAnnotation dataSyncAnnotation = (DataSyncAnnotation)annotation;
            return dataSyncAnnotation.getDataSyncType();
        }
        if (annotation instanceof DataSyncOutAnnotation) {
            DataSyncOutAnnotation dataSyncAnnotation = (DataSyncOutAnnotation)annotation;
            return dataSyncAnnotation.getDataSyncType();
        }
        return null;
    }

    public static Map<String, Object> getBeansByAnnotation(Class clazz) {
        Map beans = applicationContext.getBeansWithAnnotation(clazz);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : beans.keySet()) {
            Object entityService = beans.get(key);
            Class<?> beanClass = entityService.getClass();
            if ("Proxy".equals(beanClass.getSuperclass().getSimpleName())) {
                Advised advised = (Advised)entityService;
                SingletonTargetSource singTarget = (SingletonTargetSource)advised.getTargetSource();
                Object target = singTarget.getTarget();
                result.put(key, target);
                continue;
            }
            result.put(key, entityService);
        }
        return result;
    }
}

