/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.text.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static byte[] File2byte(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byte2File(byte[] buf, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String generatingFileNameByDate(String fileName) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String str = sdf.format(date);
        return fileName + "_" + str;
    }

    public static String createFileName(String fileType) {
        StringBuffer fileName = new StringBuffer();
        Date now = new Date();
        int rannum = (int)(Math.random() * 89999.0 + 10000.0);
        return fileName.append(now.getTime()).append(rannum).append(".").append(fileType).toString();
    }

    public static String getFileExtension(String fileName) {
        if (!fileName.isEmpty()) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static void deleteFolder(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    FileUtil.deleteFolder(f.getAbsolutePath());
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }

    public static void deleteFile(File folder, Date d) {
        File[] files;
        for (File f : files = folder.listFiles()) {
            if (f.isDirectory()) {
                FileUtil.deleteFile(f, d);
                if (f.list().length != 0) continue;
                f.delete();
                continue;
            }
            if (f.lastModified() >= d.getTime()) continue;
            f.delete();
        }
    }

    public static void copyFolder(File resFile, File objFolderFile) throws IOException {
        if (!resFile.exists()) {
            return;
        }
        if (!objFolderFile.exists()) {
            objFolderFile.mkdirs();
        }
        if (resFile.isFile()) {
            int length;
            File objFile = new File(objFolderFile.getPath() + File.separator + resFile.getName());
            FileInputStream ins = new FileInputStream(resFile);
            FileOutputStream outs = new FileOutputStream(objFile);
            byte[] buffer = new byte[524288];
            while ((length = ((InputStream)ins).read(buffer)) != -1) {
                outs.write(buffer, 0, length);
            }
            ((InputStream)ins).close();
            outs.flush();
            outs.close();
        } else {
            String objFolder = objFolderFile.getPath() + File.separator + resFile.getName();
            File _objFolderFile = new File(objFolder);
            _objFolderFile.mkdirs();
            for (File sf : resFile.listFiles()) {
                FileUtil.copyFolder(sf, new File(objFolder));
            }
        }
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFile(byte[] bytes, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + "\\" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static String writeTxtFile(String readStr, String type, String tempFolder, int num) {
        try {
            String basePath = tempFolder;
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;
            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("\u6587\u4ef6\u5939\u5df2\u521b\u5efa");
            }
            String fullFilePath = filePath + fileName + "_" + num + "_" + DateUtil.getCurrentDateTime("yyyyMMddHHmmss") + fileType;
            File newFile = new File(fullFilePath);
            Files.write((byte[])readStr.getBytes(), (File)newFile);
            return fullFilePath;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String writeTxtFile(String readStr, String type, String tempFolder) {
        try {
            String basePath = tempFolder;
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;
            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("\u6587\u4ef6\u5939\u5df2\u521b\u5efa");
            }
            String fullFilePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime("yyyyMMddHHmmss") + fileType;
            File newFile = new File(fullFilePath);
            Files.write((byte[])readStr.getBytes(), (File)newFile);
            return fullFilePath;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String zipFiles(List<String> filePaths, String strZipPath) {
        byte[] buffer = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(strZipPath));
            ArrayList files = Lists.newArrayList();
            for (String filePath : filePaths) {
                File file;
                if (!StringUtil.isNotEmpty(filePath) || !(file = new File(filePath)).exists()) continue;
                files.add(file);
            }
            for (File file : files) {
                int len;
                FileInputStream fis = new FileInputStream(file);
                out.setEncoding("utf8");
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.closeEntry();
                fis.close();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strZipPath;
    }

    public static void copyDir(String oldPath, String newPath) throws IOException {
        File file = new File(oldPath);
        String[] filePath = file.list();
        if (!new File(newPath).exists()) {
            new File(newPath).mkdir();
        }
        if (filePath == null) {
            return;
        }
        for (int i = 0; i < filePath.length; ++i) {
            if (new File(oldPath + File.separator + filePath[i]).isDirectory()) {
                FileUtil.copyDir(oldPath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
            }
            if (!new File(oldPath + File.separator + filePath[i]).isFile()) continue;
            File from = new File(oldPath + File.separator + filePath[i]);
            File to = new File(newPath + File.separator + filePath[i]);
            if (to.exists()) continue;
            Files.copy((File)from, (File)to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reNameFile(String oldPath, String newPath, String newFileName) {
        FileInputStream is = null;
        FileOutputStream out = null;
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            File newDir = new File(newPath);
            if (!newDir.exists()) {
                newDir.mkdirs();
            }
            if (oldfile.exists()) {
                is = new FileInputStream(oldPath);
                out = new FileOutputStream(newPath + File.separator + newFileName);
                byte[] buffer = new byte[1444];
                while ((byteread = is.read(buffer)) != -1) {
                    bytesum += byteread;
                    out.write(buffer, 0, byteread);
                }
                is.close();
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null || out != null) {
                try {
                    is.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String filePath, String downLoadName, HttpServletResponse response) {
        FileInputStream is = null;
        OutputStream out = null;
        try {
            File file = new File(filePath);
            if (file != null) {
                response.setContentType("octets/stream");
                response.addHeader("Content-Type", "text/html; charset=utf-8");
                downLoadName = new String(downLoadName.getBytes("gbk"), "iso8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
                is = new FileInputStream(file);
                out = response.getOutputStream();
                int i = 0;
                while ((i = is.read()) != -1) {
                    out.write(i);
                }
                is.close();
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null || out != null) {
                try {
                    is.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String filePath, String downLoadName, HttpServletRequest request, HttpServletResponse response) {
        InputStream is = null;
        OutputStream out = null;
        try {
            response.setContentType("octets/stream");
            response.addHeader("Content-Type", "text/html; charset=utf-8");
            downLoadName = new String(downLoadName.getBytes("gbk"), "iso8859-1");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
            is = request.getServletContext().getResourceAsStream(filePath);
            out = response.getOutputStream();
            int i = 0;
            while ((i = is.read()) != -1) {
                out.write(i);
            }
            is.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null || out != null) {
                try {
                    is.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void deleteFileList(List<String> fileList) {
        for (String filePath : fileList) {
            File file = new File(filePath);
            if (!file.exists() || !file.isFile()) continue;
            file.delete();
        }
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public static String getFileNameByPath(String filePath) {
        File file = new File(filePath);
        return file.getName();
    }

    public static String getFileNameByDateInterregional(Date start, Date end) {
        String startTime = com.xiaoleilu.hutool.date.DateUtil.format((Date)start, (String)"yyyyMMdd");
        String endTime = com.xiaoleilu.hutool.date.DateUtil.format((Date)end, (String)"yyyyMMdd");
        if (StringUtils.isBlank((CharSequence)startTime)) {
            startTime = String.valueOf(LocalDate.now());
        }
        if (StringUtils.isBlank((CharSequence)endTime)) {
            endTime = String.valueOf(LocalDate.now());
        }
        return startTime + "-" + endTime + "\u8865\u8d34\u4eba\u5458\u82b1\u540d\u518c";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTempFile(String oldPath, String newPath, HttpServletRequest request) {
        InputStream is = null;
        OutputStream out = null;
        try {
            is = request.getServletContext().getResourceAsStream(oldPath);
            int bytesum = 0;
            int byteread = 0;
            if (is != null) {
                out = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = is.read(buffer)) != -1) {
                    bytesum += byteread;
                    out.write(buffer, 0, byteread);
                }
                is.close();
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null || out != null) {
                try {
                    is.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String remoteFilePath, String localFilePath) throws Exception {
        URL urlfile = null;
        HttpURLConnection httpUrl = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        File f = new File(localFilePath);
        try {
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            urlfile = new URL(remoteFilePath);
            httpUrl = (HttpURLConnection)urlfile.openConnection();
            httpUrl.connect();
            bis = new BufferedInputStream(httpUrl.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(f));
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = bis.read(b)) != -1) {
                ((BufferedOutputStream)bos).write(b, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            bis.close();
            httpUrl.disconnect();
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

