/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.InputAddFriendRequest;
import cn.wildfirechat.pojos.InputBlacklistRequest;
import cn.wildfirechat.pojos.InputGetAlias;
import cn.wildfirechat.pojos.InputUpdateAlias;
import cn.wildfirechat.pojos.InputUpdateFriendExtra;
import cn.wildfirechat.pojos.InputUpdateFriendStatusRequest;
import cn.wildfirechat.pojos.InputUserId;
import cn.wildfirechat.pojos.OutputGetAlias;
import cn.wildfirechat.pojos.OutputStringList;
import cn.wildfirechat.pojos.RelationPojo;
import cn.wildfirechat.pojos.StringPairPojo;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.AdminHttpUtils;

public class RelationAdmin {
    public static IMResult<Void> setUserFriend(String userId, String targetId, boolean isFriend, String extra) throws Exception {
        String path = "/admin/friend/status";
        InputUpdateFriendStatusRequest input = new InputUpdateFriendStatusRequest();
        input.setUserId(userId);
        input.setFriendUid(targetId);
        input.setStatus(isFriend ? 0 : 1);
        input.setExtra(extra);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputStringList> getFriendList(String userId) throws Exception {
        String path = "/admin/friend/list";
        InputUserId input = new InputUserId();
        input.setUserId(userId);
        return AdminHttpUtils.httpJsonPost(path, input, OutputStringList.class);
    }

    public static IMResult<Void> setUserBlacklist(String userId, String targetId, boolean isBlacklist) throws Exception {
        String path = "/admin/blacklist/status";
        InputBlacklistRequest input = new InputBlacklistRequest();
        input.setUserId(userId);
        input.setTargetUid(targetId);
        input.setStatus(isBlacklist ? 2 : 1);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputStringList> getUserBlacklist(String userId) throws Exception {
        String path = "/admin/blacklist/list";
        InputUserId input = new InputUserId();
        input.setUserId(userId);
        return AdminHttpUtils.httpJsonPost(path, input, OutputStringList.class);
    }

    public static IMResult<Void> updateFriendAlias(String operator, String targetId, String alias) throws Exception {
        String path = "/admin/friend/set_alias";
        InputUpdateAlias input = new InputUpdateAlias();
        input.setOperator(operator);
        input.setTargetId(targetId);
        input.setAlias(alias);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputGetAlias> getFriendAlias(String operator, String targetId) throws Exception {
        String path = "/admin/friend/get_alias";
        InputGetAlias input = new InputGetAlias();
        input.setOperator(operator);
        input.setTargetId(targetId);
        return AdminHttpUtils.httpJsonPost(path, input, OutputGetAlias.class);
    }

    public static IMResult<Void> updateFriendExtra(String operator, String targetId, String extra) throws Exception {
        String path = "/admin/friend/set_extra";
        InputUpdateFriendExtra input = new InputUpdateFriendExtra();
        input.setOperator(operator);
        input.setTargetId(targetId);
        input.setExtra(extra);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<Void> sendFriendRequest(String userId, String targetId, String reason, boolean force) throws Exception {
        String path = "/admin/friend/send_request";
        InputAddFriendRequest input = new InputAddFriendRequest();
        input.setUserId(userId);
        input.setFriendUid(targetId);
        input.setReason(reason);
        input.setForce(force);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<RelationPojo> getRelation(String userId, String targetId) throws Exception {
        String path = "/admin/relation/get";
        StringPairPojo input = new StringPairPojo(userId, targetId);
        return AdminHttpUtils.httpJsonPost(path, input, RelationPojo.class);
    }
}

