package com.bcxin.risk.constant;

import com.bcxin.risk.sys.resources.ConfigResources;

/**
 * <b>Redis Key 值常量 </b>
 * @author 罗鹏
 */
public final class RedisKeyConst {

	private RedisKeyConst(){} //空的构造函数，避免实例化该类
	
	private final static String ENVI = "PSS";

	private final static String COLON = ":";

	private final static String MODULE_SYS = "SYS";

	private final static String MODULE_BUSINESS = "BUSINESS";

	private final static String REDIS_PREFIX_KEY = ENVI + COLON + "SB" + COLON + ConfigResources.PROFILE_ENVI + COLON;

	/**
	 * 一分钟
	 */
	public final static int TIMEOUT_ONE_MIN = 60;

	/**
	 * 三分钟
	 */
	public final static int TIMEOUT_THREE_MIN = 180;

	/**
	 * 五分钟
	 */
	public final static int TIMEOUT_FIVE_MIN = 300;

	/**
	 * 十分钟
	 */
	public final static int TIMEOUT_TEN_MIN = 600;

	/**
	 * 一小时
	 */
	public final static int TIMEOUT_ONE_HOUR = 3600;

	/**
	 * 半天
	 */
	public final static int TIMEOUT_HALF_DAY = 43200;

	/**
	 * 一天
	 */
	public final static int TIMEOUT_ONE_DAY = 86400;

	/**
	 * 一周
	 */
	public final static int TIMEOUT_ONE_WEEK = 604800;


	/**
	 * dict配置表
	 */
	public final static String REDIS_KEY_DICT = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "DICT";


	/**
	 * 区域配置表
	 */
	public final static String REDIS_KEY_REGION = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "REGION";

	/**
	 * 区域配置表，省
	 */
	public final static String REDIS_KEY_REGION_PROVINCE = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "REGION_PROVINCE";

	/**
	 * 区域配置表，市
	 */
	public final static String REDIS_KEY_REGION_CITY = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "REGION_CITY";


	/**
	 * 区域配置表，区
	 */
	public final static String REDIS_KEY_REGION_AREA = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "REGION_AREA";

	/**
	 * 材料多选项配置表
	 */
	public final static String REDIS_KEY_MATERIAL_OPTION = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "MATERIAL_OPTION";


	/**
	 * 可销售的区域配置表
	 */
	public final static String REDIS_KEY_MARKET_REGION = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "MARKET_REGION";

	/**
	 * 可销售的区域配置表 省
	 */
	public final static String REDIS_KEY_MARKET_REGION_PROVINCE = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "MARKET_REGION_PROVINCE";

	/**
	 * 可销售的区域配置表 市
	 */
	public final static String REDIS_KEY_MARKET_REGION_CITY = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "MARKET_REGION_CITY";

	/**
	 * 材料分类模板表
	 */
	public final static String REDIS_KEY_MATERIAL_CLASS_TEMPLATE = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "MATERIAL_ATTR_TEMPLATE";

	/**
	 * 材料菜单模板表
	 */
	public final static String REDIS_KEY_MATERIAL_MENU_TEMPLATE = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "MATERIAL_MENU_TEMPLATE";


	/**
	 * 材料元素模板表
	 */
	public final static String REDIS_KEY_MATERIAL_ATTR_TEMPLATE = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "MATERIAL_ATTR_TEMPLATE";


	/**
	 * 用户
	 */
	public final static String REDIS_KEY_USER_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "USER_";

	/**
	 * 注册验证码
	 */
	public final static String REDIS_KEY_REGISTER_CAPTCHA_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "REGISTER_CAPTCHA_";

	/**
	 * 找回密码验证码
	 */
	public final static String REDIS_KEY_RESET_CAPTCHA_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "RESET_CAPTCHA_";

	/**
	 * 绑定账号验证码
	 */
	public final static String REDIS_KEY_BIND_CAPTCHA_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "BIND_CAPTCHA_";

	/**
	 * 用户超时登录
	 */
	public final static String REDIS_KEY_USER_OVERTIME_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "USER_OVERTIME_";
	/**
	 * 小程序登录token
	 */
	public final static String REDIS_KEY_WCUSER_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "WCUSER_";
	/**
	 * 材料填写分享token
	 */
	public final static String REDIS_KEY_SHARESAVE_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "SHARESAVE_";


}
