package com.bcxin.risk.constant;

/**
 * 
 * <b>字典常量字段库 </b>
 * 
 * @author  xiangyaoqi
 * @date 2017年05月02日
 * @注意事项 </b>
 * <b>
 */
public final class DictConst {

	private DictConst(){} //空的构造函数，避免实例化该类

	/**
	 * 基础的，是和否
	 */
	public final static String Y = "1";
	public final static String N = "0";


	public final static int OP_LOGIN = 0;
	public final static int OP_SELECT = 1;
	public final static int OP_SAVE = 2;
	public final static int OP_UPDATE = 3;
	public final static int OP_DELETE = 4;

	/**
	 * 码表基本信息
	 */

    /* 交易产生对象 TRANSACTIONOBJECT */
	public final static String ACTIVITYSTATUS_YQX = "0";    //活动状态_已取消
	public final static String ACTIVITYSTATUS_SQZ = "10";    //活动状态_申请中
	public final static String ACTIVITYSTATUS_SPZ = "20";    //活动状态_审批中
	public final static String ACTIVITYSTATUS_SPDH = "25";    //活动状态_审批打回
	public final static String ACTIVITYSTATUS_BXK = "30";    //活动状态_不许可
	public final static String ACTIVITYSTATUS_CBJB = "40";    //活动状态_筹备举办（通过当前时间和活动时间判断，未到活动时间为筹备中，否则为举办中）
	public final static String ACTIVITYSTATUS_HDJS = "50";    //活动状态_结束

	public final static String ACTIVITYSTATUS_DEL = "88";    //活动状态_已删除
	public final static String ACTIVITYSTATUS_YFQ = "88";    //活动状态_已废弃（活动申请了，但是有重复活动名称，）


	/*初审状态*/
	public final static String PRIMARYSTATUS_CSZ = "10";    //初审中（提交初审）（已提交评定）
	public final static String PRIMARYSTATUS_CSXG = "20";   //初审修改（初审退回）
	public final static String PRIMARYSTATUS_CSTG = "30";    //初审通过（初审通过）（已评定）

	/*受理状态*/
	public final static String SLSTATUS_SLZ = "SL10"; //受理中
	public final static String SLSTATUS_BSL = "SL20";//不予受理
	public final static String SLSTATUS_SL = "SL30";//受理通过--》审批中

	/* 等级评定级别 */
	public final static String GRADERANK_ONE = "1"; //一级
	public final static String GRADERANK_TWO = "2"; //二级
	public final static String GRADERANK_THREE = "3"; //三级

	/* 活动材料类型 */
	public final static String ACTIVITYMATERIALTYPE_PGBG = "1";    //材料类型_评估报告
	public final static String ACTIVITYMATERIALTYPE_PGBG_GEN = "01";  //材料类型_评估报告_系统自动生成报告
	public final static String ACTIVITYMATERIALTYPE_DZBD = "2";    //材料类型_电子保单
	public final static String ACTIVITYMATERIALTYPE_JLBG_KS = "3";   //材料类型_监理报告（活动开始前）
	public final static String ACTIVITYMATERIALTYPE_JLBG_JS = "10";  //材料类型_监理报告（活动结束后）
	public final static String ACTIVITYMATERIALTYPE_DYJDTKBG = "4";    //材料类型_第一阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_DEJDTKBG = "5";    //材料类型_第二阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_DSJDTKBG = "6";    //材料类型_第三阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_PGCL = "7";    //材料类型_评估材料
	public final static String ACTIVITYMATERIALTYPE_BPCL = "8";    //材料类型_报批材料
	public final static String ACTIVITYMATERIALTYPE_BPCL_OLD = "81";    //材料类型_报批材料（如果审批打回，则会出现旧版的报批材料）
	public final static String ACTIVITYMATERIALTYPE_FKLSCL = "11";  //材料类型_风险控制落实说明材料
	public final static String ACTIVITYMATERIALTYPE_AQGZFA = "12";  //材料类型_安全工作方案
	public final static String ACTIVITYMATERIALTYPE_SFZM = "13";  //材料类型_身份证明，资质证明
	public final static String ACTIVITYMATERIALTYPE_HDFA = "14";  //材料类型_活动方案说明
	public final static String ACTIVITYMATERIALTYPE_HDCSZM = "15";  //材料类型_活动场所证明
	public final static String ACTIVITYMATERIALTYPE_CBZZM = "16";  //材料类型_承办者身份证明


	/**
	 * 材料上传方式
	 */
	public final static String MATERIALCOMMITWAY_SELF = "1";    //自主上传
	public final static String MATERIALCOMMITWAY_ONLINE = "2";  //在线购买


	/* 活动来源 */
	public final static String ACTIVITYSOURCE_ZXSB = "1";  //在线申报
	public final static String ACTIVITYSOURCE_XTLR = "2";  //系统录入
	public final static String ACTIVITYSOURCE_ZXCJ = "3";  //在线创建


	/* 机构类型 ORGTYPE */
	public final static String ORGTYPE_CBDW = "1";    //机构类型_承办单位
	public final static String ORGTYPE_ZJJG = "2";    //机构类型_专家机构
	public final static String ORGTYPE_GAJG = "3";    //机构类型_公安机构
	public final static String ORGTYPE_GLJG = "4";    //机构类型_管理机构
	public final static String ORGTYPE_DSFFWJG = "5";    //机构类型_第三方服务机构
	public final static String ORGTYPE_SERVICEORG = "6";    //机构类型_服务机构



	/* 系统日志类型 LOGTYPE */
	public final static String LOGTYPE_XTYC = "1";    //系统日志类型_系统异常
	public final static String LOGTYPE_DSRW = "2";    //系统日志类型_定时任务


	/* 新闻类型 NEWSTYPE */
	public final static String NEWSTYPE_GGTZ = "0";            //新闻类型_公告通知
	public final static String NEWSTYPE_HYZX = "1";            //新闻类型_行业资讯
	public final static String NEWSTYPE_HDXX = "2";            //新闻类型_活动信息
	public final static String NEWSTYPE_ZCFL = "3";            //新闻类型_政策法律


	/* 用户类型 USERTYPE */
	public final static String USERTYPE_CBDWYH = "1";    //用户类型_承办单位用户
	public final static String USERTYPE_ZJJGYH = "2";    //用户类型_专家机构用户
	public final static String USERTYPE_GAJGYH = "3";    //用户类型_公安机构用户
	public final static String USERTYPE_GLJGYH = "4";    //用户类型_管理机构用户
	public final static String USERTYPE_ZJGLY = "15";    //用户类型_专家管理员
	public final static String USERTYPE_GOV = "20";    //用户类型_承办单位政府用户
	public final static String USERTYPE_SERVICEORG = "21";    //用户类型_服务商用户



	/* 服务机构类型 SERVICEORGTYPE */
	public final static String SERVICEORGTYPE_FXPGJG = "1";    //服务机构类型_风险评估机构
	public final static String SERVICEORGTYPE_CYGS = "2";    //服务机构类型_餐饮公司
	public final static String SERVICEORGTYPE_FBGS = "3";    //服务机构类型_防爆公司
	public final static String SERVICEORGTYPE_PWGS = "4";    //服务机构类型_票务公司
	public final static String SERVICEORGTYPE_BAGS = "5";    //服务机构类型_保安公司
	public final static String SERVICEORGTYPE_CZGS = "6";    //服务机构类型_场租公司
	public final static String SERVICEORGTYPE_LJGS = "7";    //服务机构类型_临建公司
	public final static String SERVICEORGTYPE_AJMGS = "8";    //服务机构类型_安检门公司
	public final static String SERVICEORGTYPE_JLGS = "9";    //服务机构类型_监理公司


	/*  -------------------------活动类型---------------------**/
	public final static String ACTIVITYTYPE_TYBSHD 		= "100001";	   //活动类型_体育比赛活动
	public final static String ACTIVITYTYPE_WYYCHD 		= "100002";    //活动类型_演唱会、音乐会等文艺演出活动
	public final static String ACTIVITYTYPE_ZLZXDHD 	= "100003";   //活动类型_展览会、展销会、交流会等活动
	public final static String ACTIVITYTYPE_YYDHHD 		= "100004";    //活动类型_游园、灯会、庙会、花会、焰火晚会、美食节等活动
	public final static String ACTIVITYTYPE_ZPHHD 		= "100005";     //活动类型_招聘会、推介会、现场开奖的彩票销售等活动
	public final static String ACTIVITYTYPE_GYCSHD 		= "100006";    //活动类型_公益慈善活动
	public final static String ACTIVITYTYPE_QT 			= "100007";        //活动类型_其他类活动


	/* 场地类型 ADDRESSTYPE */
	public final static String ADDRESSTYPE_SN = "1";            //全封闭（室内）
	public final static String ADDRESSTYPE_SNLT = "2";            //半封闭（室内露天）
	public final static String ADDRESSTYPE_SW = "3";            //开放式（室外）
	public final static String ADDRESSTYPE_SNSW = "4";        //室内+室外
	public final static String ADDRESSTYPE_QT = "5";        //其他


	/* 审批状态 APPROVALSTATUS */
	public final static String APPROVALSTATUS_DSH = "1";    //审批状态_待审批
	public final static String APPROVALSTATUS_SHTG = "2";    //审批状态_审批许可
	public final static String APPROVALSTATUS_SHBTG = "3";    //审批状态_审批不许可
	public final static String APPROVALSTATUS_SHDH = "4";    //审批状态_审批打回

	public final static String APPROVALSTATUS_SP_DSH = "NONE";    //审批状态_待审批
	public final static String APPROVALSTATUS_SP_SHTG = "YES";    //审批状态_审批许可
	public final static String APPROVALSTATUS_SP_SHBTG = "NO";    //审批状态_审批不许可
	public final static String APPROVALSTATUS_SP_SHDH = "REJECT";    //审批状态_审批打回


	/* 报告状态类型 REPORTSTATUS */
	public final static String REPORTSTATUS_COLLECT = "1";          //资料收集
	public final static String REPORTSTATUS_DRAFT = "2";           //撰写中
	public final static String REPORTSTATUS_SUBMIT = "3";         //已提交


	/**
	 * 等级评定类型
	 */
	public final static String GRADERANKTYPE_PD = "10";    //等级评定
	public final static String GRADERANKTYPE_TK = "11";    //要求踏勘
	public final static String GRADERANKTYPE_CL = "12";    //要求补充材料
	public final static String GRADERANKTYPE_SQCP = "13";    //承办方申请重评
	public final static String GRADERANKTYPE_BTY = "14";    //公安不同意调整等级评定
	public final static String GRADERANKTYPE_CP = "15";    //公安重新调整等级评定
	public final static String GRADERANKTYPE_CTPD = "16";    //承办方重新提交评定
	public final static String GRADERANKTYPE_TJPD = "17";    //承办方提交评定

	/* 审核结果 APPROVEACTIVE */
	public final static String APPROVEACTIVE_SHZ = "0";    //审核结果_审核中
	public final static String APPROVEACTIVE_SHCG = "1";    //审核结果_审核成功
	public final static String APPROVEACTIVE_SHWTG = "2";    //审核结果_审核未通过


	/* 阅读状态 READSTATUS */
	public final static String READSTATUS_WD = "0";    //阅读状态_未读
	public final static String READSTATUS_YD = "1";    //阅读状态_已读


	/* 活动状态阶段 ACTIVITYSUBSTEP */
	public final static String ACTIVITYSUBSTEP_CGCJXM = "10";    //活动状态阶段_成功创建了项目
	public final static String ACTIVITYSUBSTEP_CGZFLYF = "15";    //活动状态阶段_成功支付了费用
	public final static String ACTIVITYSUBSTEP_CGTJLCL = "20";    //活动状态阶段_成功提交了材料
	public final static String ACTIVITYSUBSTEP_DYJDTKYWC = "25";    //活动状态阶段_第一阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_FXPGBGYWC = "30";    //活动状态阶段_风险评估报告已完成
	public final static String ACTIVITYSUBSTEP_HDSPBTG = "35";    //活动状态阶段_活动审批不通过
	public final static String ACTIVITYSUBSTEP_HDSPTG = "40";    //活动状态阶段_活动审批通过
	public final static String ACTIVITYSUBSTEP_HDSPDH = "42";    //活动状态阶段_活动审批打回
	public final static String ACTIVITYSUBSTEP_JLSCBYWC = "43";    //活动状态阶段_监理检查表已完成
	public final static String ACTIVITYSUBSTEP_DRJDTKYWC = "45";    //活动状态阶段_第二阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_JCBYWC = "48";     // 活动状态阶段_检查表已完成
	public final static String ACTIVITYSUBSTEP_JLBGYWC = "50";    //活动状态阶段_监理报告已完成
	public final static String ACTIVITYSUBSTEP_DSJDTKYWC = "55";    //活动状态阶段_第三阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_XMJS = "60";    //活动状态阶段_项目结束


	/* 户外场地类型 OUTDOORTYPE */
	public final static String OUTDOORTYPE_XXGC = "1";        //户外场地类型_学校体育场，校内广场
	public final static String OUTDOORTYPE_GYGC = "2";       //户外场地类型_公园，文化广场
	public final static String OUTDOORTYPE_SYQGC = "3";        //户外场地类型_商业区广场
	public final static String OUTDOORTYPE_HBSD = "4";        //户外场地类型_海边沙滩，山地，水上，
	public final static String OUTDOORTYPE_QT = "5";          //户外场地类型_其他


	/* 展会类型 EXHIBITIONTYPE */
	public final static String EXHIBITIONTYPE_ZY = "1";   //专业类
	public final static String EXHIBITIONTYPE_XF = "2";  //消费类
	public final static String EXHIBITIONTYPE_ZH = "3";  //综合类

	/* 证件类型 IDTYPE */
	public final static String IDTYPE_IDCARD = "0";                                    //身份证
	public final static String IDTYPE_OFFICERCERTIFICATE = "1";                        //军官证
	public final static String IDTYPE_PASSPORT = "2";                                    //护照
	public final static String IDTYPE_CARLICENCE = "3";                                //驾驶执照
	public final static String IDTYPE_HVPSANDMTP = "4";                                //港澳回乡证或台胞证
	public final static String IDTYPE_HOMECARD = "5";                                    //返乡证
	public final static String IDTYPE_OTHER = "6";                                    //其他
	public final static String IDTYPE_BUSINESSLICENSE = "7";                            //营业执照
	public final static String IDTYPE_TAXREGISTRATIONCERTIFICATE = "8";             //税务登记证
	public final static String IDTYPE_ORGANIZATIONCODECERTIFICATE = "9";            //组织机构代码证


	/* 性别 GENDER */
	public final static String GENDER_FEMALE = "0";                                //女
	public final static String GENDER_MALE = "1";                                    //男
	public final static String GENDER_UNKNOWN = "3";                                //未知


	/* 保单活动类型 POLICY_ACTIVITYTYPE */
	public final static String POLICY_ACTIVITYTYPE_EXHIBITION = "0";                            //展览展销类
	public final static String POLICY_ACTIVITYTYPE_LITERATURE = "1";                            //文艺演出类
	public final static String POLICY_ACTIVITYTYPE_SPORTS = "2";                                //体育赛事类
	public final static String POLICY_ACTIVITYTYPE_GARDENLANTERN = "3";                        //其他类活动（游园、灯会、庙会、花会、焰火晚会、人才招聘会、现场开奖的彩票销售等）
	public final static String POLICY_ACTIVITYTYPE_OTHER = "4";                                //其他


	/* 保单活动规模 POLICY_ACTIVITYSCALE */
	public final static String POLICY_ACTIVITYSCALE_CPIC_BELOW = "0";                         //5000人以下
	public final static String POLICY_ACTIVITYSCALE_CPIC_MIDDLE = "1";                        //5000人-30000人
	public final static String POLICY_ACTIVITYSCALE_CPIC_UP = "2";                            //30000人以上
	public final static String POLICY_ACTIVITYSCALE_HT_BELOW = "3";                           //5000人以下（含5000人）
	public final static String POLICY_ACTIVITYSCALE_HT_MIDDLE = "4";                          //5000人-10000人（含10000人）
	public final static String POLICY_ACTIVITYSCALE_HT_SE_MIDDLE = "5";                       //10000人-50000人（含50000人）
	public final static String POLICY_ACTIVITYSCALE_HT_UP = "6";                               //50000人以上


	/* 保单活动天数 POLICY_ACTIVITYPERIOD */
	public final static String POLICY_ACTIVITYPERIOD_BELOW = "0";                           //三天以内
	public final static String POLICY_ACTIVITYPERIOD_MIDDLE = "1";                          //三天-七天
	public final static String POLICY_ACTIVITYPERIOD_UP = "2";                         		//七天以上


	/* 有无消防措施 POLICY_ACTIVITYFIREFIGHT */
	public final static String POLICY_ACTIVITYFIREFIGHT_ACCEPTANCE = "0";                           //有消防验收
	public final static String POLICY_ACTIVITYFIREFIGHT_EXTINGUISHER = "2";                         //无消防验收但配备灭火器
	public final static String POLICY_ACTIVITYFIREFIGHT_NO_EXTINGUISHER = "3";                      //无消防验收无灭火器


	/* 场地类型 POLICY_ACTIVITYLOCAL */
	public final static String POLICY_ACTIVITYLOCAL_INDOOR = "0";                           //室内场馆
	public final static String POLICY_ACTIVITYLOCAL_OPEN = "1";                           	//露天场馆
	public final static String POLICY_ACTIVITYLOCAL_OUTDOOR = "2";                          //户外地点


	/* 保单赔偿金额 POLICY_ACTIVITYQUOTA */
	public final static String POLICY_ACTIVITYQUOTA_PIC_LEVEL_ONE= "0";                //人民币400万≤累计赔偿限额＜人民币600万
	public final static String POLICY_ACTIVITYQUOTA_CPIC_LEVEL_TWO= "1";               //人民币600万≤累计赔偿限额＜人民币800万
	public final static String POLICY_ACTIVITYQUOTA_CPIC_LEVEL_THREE= "2";             //人民币800万≤累计赔偿限额＜人民币1000万
	public final static String POLICY_ACTIVITYQUOTA_CPIC_LEVEL_FOUR= "3";              //人民币1000万≤累计赔偿限额＜人民币1500万
	public final static String POLICY_ACTIVITYQUOTA_PIC_LEVEL_FIVE= "4";               //人民币1500万≤累计赔偿限额＜人民币2000万
	public final static String POLICY_ACTIVITYQUOTA_PIC_LEVEL_SIX= "5";                //累计赔偿限额≥人民币2000万
	public final static String POLICY_ACTIVITYQUOTA_HT_LEVEL_ONE= "6";                 //人民币500万≤累计赔偿限额＜人民币3500万
	public final static String POLICY_ACTIVITYQUOTA_HT_LEVEL_TWO= "7";                 //人民币1000万≤累计赔偿限额＜人民币3500万
	public final static String POLICY_ACTIVITYQUOTA_HT_LEVEL_THREE= "8";               //人民币1500万≤累计赔偿限额＜人民币3500万
	public final static String POLICY_ACTIVITYQUOTA_HT_LEVEL_FOUR= "9";                //人民币3500万<累计赔偿限额

	/* 有无状态 WHETHER */
	public final static String WHETHER_HAVE= "1";                //有
	public final static String WHETHER_WITHOUT= "0";               //无


	/*勘查阶段 SURVEYSTEP*/
	public final static String SURVEYSTEP_FIRST = "1"; //第一阶段勘查
	public final static String SURVEYSTEP_SECOND = "2"; //第二阶段勘查
	public final static String SURVEYSTEP_THIRD = "3"; //第三阶段勘查


	/* 任务接受状态 ACCEPTSTATUS */
	public final static String ACCEPTSTATUS_NON = "0"; //未接收
	public final static String ACCEPTSTATUS_YES = "1"; //已接收
	public final static String ACCEPTSTATUS_TRANSFER = "2"; //申请转交


	/* 任务状态 TASKSTATUS */
	public final static String TASKSTATUS_NON = "1"; //未完成
	public final static String TASKSTATUS_CONTINUE = "2"; //进行中
	public final static String TASKSTATUS_COMPLETE = "3"; //已完成
	public final static String TASKSTATUS_CLOSE = "4"; //任务关闭
	public final static String TASKSTATUS_ASSIGNED = "5"; //已分配


	/* 任务类型 TASKTYPE */
	public final static String TASKTYPE_FILEUPLOAD= "1"; // 材料上传
	public final static String TASKTYPE_SURVEY= "2"; // 现场勘查
	public final static String TASKTYPE_FILEVERIFY = "3"; // 材料审核
	public final static String TASKTYPE_FIRSTDRAFT = "4"; // 撰写初稿
	public final static String TASKTYPE_FIRSTAUDIT = "5"; // 报告一审
	public final static String TASKTYPE_EXPERTAUDIT = "6"; // 专家审核
	public final static String TASKTYPE_REVIEW = "7"; // 报告复核
	public final static String TASKTYPE_PRINT = "8"; // 报告导出打印
	public final static String TASKTYPE_VIDEO = "9"; // 视频任务


	/* 勘查任务状态 SURVEYTASKSTATUS */
	public final static String SURVEYTASKSTATUS_XRW = "1"; //新任务
	public final static String URVEYTASKSTATUS_CS = "2"; //超时
	public final static String URVEYTASKSTATUS_JXZ = "3"; //进行中
	public final static String URVEYTASKSTATUS_TKJSYJB = "4"; //勘察结束已办结
	public final static String URVEYTASKSTATUS_YJJ = "5"; //已拒绝
	public final static String URVEYTASKSTATUS_YZJ = "6"; //已转交
	public final static String URVEYTASKSTATUS_ZJSHZ = "7"; //转交审核中
	public final static String URVEYTASKSTATUS_YGHDSJ = "8"; //已过活动时间
	public final static String URVEYTASKSTATUS_QT = "9"; //其他
	public final static String URVEYTASKSTATUS_QB = "10"; //全部


	/* 分配状态 ASSIGNSTATUS */
	public final static String ASSIGNSTATUS_UNDISTRIBUTED = "1"; //未分配
	public final static String ASSIGNSTATUS_NOTPASS = "2"; //不通过
	public final static String ASSIGNSTATUS_PASS = "3"; //通过
	public final static String ASSIGNSTATUS_CLOSE = "4"; //关闭


	/* 分配类型 ASSIGNTYPE */
	public final static String ASSIGNTYPE_REWJ = "1"; //任务转交
	public final static String ASSIGNTYPE_SQZJ = "2"; //申请专家


	/* 勘查问题类型 ASSIGNSTATUS */
	public final static String QUESTIONTYPE_OPEN_QUESTION = "1"; //开放问题
	public final static String QUESTIONTYPE_FIXED_QUESTION  = "2"; //固定问题
	public final static String QUESTIONTYPE_SUPPLEMENTARY_QUESTION  = "3"; //补充问题
	public final static String QUESTIONTYPE_LEGACY_QUESTION = "4"; //遗留问题

	/* 性别 SEX */
	public final static String  SEX_MEN = "1" ;           //性别_男
	public final static String  SEX_WOMEN = "2";             //性别_女
	public final static String  SEX_QT = "3";          //性别_不确定

	/* 学历 EDUCATION */
	public final static String  EDUCATION_BSYJS = "1";             //学历_博士研究生
	public final static String  EDUCATION_SSYJS = "2";             //学历_硕士研究生
	public final static String  EDUCATION_DXBK = "3";             //学历_大学本科
	public final static String  EDUCATION_DXZK = "4";             //学历_大学专科
	public final static String  EDUCATION_ZDZK = "5";             //学历_中等专科
	public final static String  EDUCATION_ZYGZ = "6" ;            //学历_职业高中
	public final static String  EDUCATION_JGXX = "7";             //学历_技工学校
	public final static String  EDUCATION_PTZX = "8";             //学历_普通中学
	public final static String  EDUCATION_CJZX = "9" ;            //学历_初级中学
	public final static String  EDUCATION_XX = "10" ;            //学历_小学
	public final static String  EDUCATION_QT = "11" ;            //学历_其他

	/* 政治面貌 POLITICAL */
	public final static String  POLITICAL_ZGDY =  "1";             //政治面貌_中共党员
	public final static String  POLITICAL_ZGYBDY = "2";             //政治面貌_中共预备党员
	public final static String  POLITICAL_GQTY = "3" ;            //政治面貌_共青团员
	public final static String  POLITICAL_MGDY = "4";             //政治面貌_民革党员
	public final static String  POLITICAL_MMMY = "5";             //政治面貌_民盟盟员
	public final static String  POLITICAL_MJHY = "6" ;            //政治面貌_民建会员
	public final static String  POLITICAL_MJHY2 = "7";             //政治面貌_民进会员
	public final static String  POLITICAL_NGDDY = "8"  ;           //政治面貌_农工党党员
	public final static String  POLITICAL_ZGDDY = "9" ;            //政治面貌_致公党党员
	public final static String  POLITICAL_JSXSDY = "10" ;            //政治面貌_九三学社社员
	public final static String  POLITICAL_TMMY = "11";            //政治面貌_台盟盟员
	public final static String  POLITICAL_WDPRS = "12";             //政治面貌_无党派人士
	public final static String  POLITICAL_QZ = "13";             //政治面貌_群众



	/*************************报告撰写****************************/

	/* 报告撰写小状态 REPORTSUBSTATUS */
	public final static String REPORTSUBSTATUS_ASSIGN = "1";    //待分配
	public final static String REPORTSUBSTATUS_DRAFT = "2";    //初稿撰写
	public final static String REPORTSUBSTATUS_FIRST= "3";     //一审
	public final static String REPORTSUBSTATUS_EXPERT = "4";    //专家审核
	public final static String REPORTSUBSTATUS_REVIEW = "5";    //复核
	public final static String REPORTSUBSTATUS_COMPLETE = "6";    //行政人员

	/* 报告撰写目录级别 COMPOSECATALOGLEVEL */
	public final static String COMPOSECATALOGLEVEL_ONE = "1";    //章
	public final static String COMPOSECATALOGLEVEL_TWO = "2";    //节
	public final static String COMPOSECATALOGLEVEL_THREE = "3";     //项
	public final static String COMPOSECATALOGLEVEL_PARAGRAPH = "4";    //段

	/* 素材元素类型 FIELDTYPE */
	public final static String FIELDTYPE_TEXT = "1";    //素材元素类型_单行文本
	public final static String FIELDTYPE_TEXTAREA = "2";    //素材元素类型_多行文本
	public final static String FIELDTYPE_NUMBER = "3";    //素材元素类型_数值
	public final static String FIELDTYPE_DATE = "4";    //素材元素类型_时间
	public final static String FIELDTYPE_IMAGE= "5";    //素材元素类型_图片
	public final static String FIELDTYPE_FILE = "6";    //素材元素类型_文件

	/* 素材对象 COMPOSECATEGORY  */
	public final static String COMPOSECATEGORY_QY = "1";    //素材元素类型_企业
	public final static String COMPOSECATEGORY_CG = "2";    //素材元素类型_场馆

	/* 内容类型 CONTENTTYPE  */
	public final static String CONTENTTYPE_DLMB = "1";    //内容类型_段落模板
	public final static String CONTENTTYPE_QY = "2";      //内容类型_企业
	public final static String CONTENTTYPE_CG = "3";      //内容类型_场馆
	public final static String CONTENTTYPE_AL = "4";      //内容类型_案例
	public final static String CONTENTTYPE_LSBG = "5";      //内容类型_历史报告
	public final static String CONTENTTYPE_QW = "6";      //内容类型_全文

	/* 任务完成程度  COMPLETE */
	public final static String COMPLETE_YES = "1";	 //任务完成程度_已全部完成
	public final static String COMPLETE_NO = "0";    //任务完成程度_未完成
	public final static String COMPLETE_PROCESS = "2";   //任务完成程度_未完成部分


    /* 顺序调整  seq */
    public final static String SEQ_ADD = "1";	 //顺序调整_增加
    public final static String SEQ_DECREASE = "0";    //顺序调整_减少


	/* 区域级别  regionLevel */
	public final static String REGIONLEVEL_PROVINCE = "1";	 // 省份
	public final static String REGIONLEVEL_CITY = "2";     // 城市
	public final static String REGIONLEVEL_AREA = "3";     // 区县
	public final static String REGIONLEVEL_UNIT = "4";     // 许可单位


	/* 材料类型 */
	public final static String MATERIALTASKTYPE_HDXX = "1";	 //生成活动信息
	public final static String MATERIALTASKTYPE_BPCL = "2";	 //生成报批材料
	public final static String MATERIALTASKTYPE_BBCL = "3";	 //生成报备材料
	public final static String MATERIALTASKTYPE_PGBG = "4";	 //生成评估报告
	public final static String MATERIALTASKTYPE_FWJG = "5";	 //生成服务机构
	public final static String MATERIALTASKTYPE_AQGZFA = "6";	 //生成安全工作方案
	public final static String MATERIALTASKTYPE_AQGZCP = "7";	 //生成安全等级重评
	public final static String MATERIALTASKTYPE_YJYA = "8";	 //生成应急预案
	public final static String MATERIALTASKTYPE_PGCL = "9";	 //生成评估材料


	/* 同步类型 */
	public final static String SYNCTASKTYPE_TJCS = "A1";   //提交初审
	public final static String SYNCTASKTYPE_CSTG = "A2";   //初审通过
	public final static String SYNCTASKTYPE_TJSP = "A3";   //提交审批
	public final static String SYNCTASKTYPE_SL = "A4";   //受理
	public final static String SYNCTASKTYPE_ZFHD = "A5";   //同步政府活动
	public final static String SYNCTASKTYPE_SPZT = "A6";   //同步状态
	public final static String SYNCTASKTYPE_BPCL = "A7";   //同步报批材料
	public final static String SYNCTASKTYPE_APPROVAL = "A8";   //同步审批日志
	public final static String SYNCTASKTYPE_ACTLOG = "A9";   //同步活动信息修改日志
	public final static String SYNCTASKTYPE_MODULE_ACTLOG = "A91";   //主体材料修改
	public final static String SYNCTASKTYPE_MATERAILLOG = "A10";   //同步活动材料修改日志
	public final static String SYNCTASKTYPE_BAGS = "A11";   //保安公司列表
	public final static String SYNCTASKTYPE_UPDATEBAGS = "A12";   //修改保安公司
	public final static String SYNCTASKTYPE_PGBG = "A13";   //同步评估报告
	public final static String SYNCTASKTYPE_INIT = "A14";   //同步活动初始信息


	public final static String SYNCTASKTYPE_XGMM = "U11";   //修改密码，修改电话，修改邮箱
	public final static String SYNCTASKTYPE_YHDJ = "U12";   //用户冻结
	public final static String SYNCTASKTYPE_YHCZ = "U13";   //检查用户是否存在
	public final static String SYNCTASKTYPE_YHZC = "U14";   //承办方用户注册
	public final static String SYNCTASKTYPE_ZFZC = "U15";   //政府单位注册

	public final static String SYNCTASKTYPE_UPDATE_COMPANY = "S16";   //修改公司信息
	public final static String SYNCTASKTYPE_SENDMESSAGE = "S20";   //推送到主站，主站生成短信，邮件，站内信


	public final static String COURSETYPE_CBF = "1";   //承办方视频

	/**
	 * 推送内网转交后的省市区到主站
	 */
	public final static String SYNCTASKTYPE_TRANSFER_ACT="S21";

	/**
	 * 推送内网升级日志结果
	 */
	public final static String SYNCTASKTYPE_UPGREAD_RESULT = "LOG100";

	// 申报系统管理员 角色代码
	public final static String SB_GLY_ROLE_CODE="gly";


	/* 通知类型 */
	public final static String NOTIFY_SYNC_WARNING = "1"; /* 同步告警通知 */


	/**
	 * 华为云短信模板
	 */
	public final static String SMSCODE_P01 = "P01";

	public final static String SMSCODE_E01 = "E01";
	public final static String SMSCODE_B02 = "B02";
	public final static String SMSCODE_B03 = "B03";
	public final static String SMSCODE_B04 = "B04";
	public final static String SMSCODE_B05 = "B05";
	public final static String SMSCODE_B06 = "B06";
	public final static String SMSCODE_B07 = "B07";
	public final static String SMSCODE_B08 = "B08";
	public final static String SMSCODE_B09 = "B09";
	public final static String SMSCODE_B10 = "B10";
	public final static String SMSCODE_B11 = "B11";
	public final static String SMSCODE_B12 = "B12";
	public final static String SMSCODE_B13 = "B13";
	public final static String SMSCODE_B14 = "B14";
	public final static String SMSCODE_B15 = "B15";
	public final static String SMSCODE_B16 = "B16";
	public final static String SMSCODE_B17 = "B17";
	public final static String SMSCODE_B18 = "B18";
	public final static String SMSCODE_B19 = "B19";
	public final static String SMSCODE_B20 = "B20";
	public final static String SMSCODE_B21 = "B21";
	public final static String SMSCODE_B22 = "B22";
	public final static String SMSCODE_B23 = "B23";
	public final static String SMSCODE_B24 = "B24";
	public final static String SMSCODE_B25 = "B25";

	//河北好差评系统
	public final static String HEBEI_GOODBAD_PUSHED = "1";//已推送
	public final static String HEBEI_GOODBAD_NOT_PUSH = "0";//未推送

	//河北申报-办件状态
	public final static String HEBEI_HANDLESTATE_SB = "收件";
	public final static String HEBEI_HANDLESTATE_SL = "受理";
	public final static String HEBEI_HANDLESTATE_ZB = "在办";
	public final static String HEBEI_HANDLESTATE_BJ = "办结";

	//河北申报-办件状态
	public final static String HEBEI_NODENAME_SB = "申报";
	public final static String HEBEI_NODENAME_SL = "受理";
	public final static String HEBEI_NODENAME_SP = "审批";
	public final static String HEBEI_NODENAME_BJ = "办结";
	public final static String HEBEI_NODENAME_JS = "结束";

	//是否重新进行等级评定
	public final static String RE_SUBMIT_YES = "1";//是
	public final static String RE_SUBMIT_NO = "2";//否

	//浙江政务头
	public final static String ZJZW_HEADER_FIRST = "zjzw:projId:";//一阶段头
	public final static String ZJZW_HEADER_SECOND = "zjzw:multiReceiveId:projId:";//二阶段头
	public final static String ZJZW_PGBG="riskReport";//评估报告
	public final static String ZJZW_CBZZM="undertaker";//承办者证明
	public final static String ZJZW_SFZM="securityPerson";//riskReport即评估报告的id
	public final static String ZJZW_HDFA="activityScheme";//活动方案
	public final static String ZJZW_BCCL="addFiles";//补充材料
	public final static String ZJZW_OTHER_BCCL="otherAddFiles";//其他补充材料
	public final static String ZJZW_AQGZFA="securityScheme";//
	public final static String ZJZW_HDCSZM="securityPermission";//活动场所证明



	public final static String ESTAND_BG_10101="ESTAND-BG-10101";//报告商品
	public final static String ESTAND_ZJ_10201="ESTAND-ZJ-10201";//专家商品
	public final static String ESTAND_TK_10301="ESTAND-TK-10301";//踏勘商品





}