package com.bcxin.risk.constant;

/**
 * <b> 省业务归属配置 </b>
 * @author ZXF
 * @create 2024/03/13 0013 15:10
 * @version
 * @注意事项 </b>
 */
public enum BusinessOwnershipEnum {
    B110000(110000, "北京市", "洪亚梨", "18898765039", 0),
    B120000(120000, "天津市", "蔡杰", "15359056172", 0),
    B130000(130000, "河北省", "蔡杰", "15359056172", 0),
    B140000(140000, "山西省", "陈雨馨", "18159366027", 0),
    B150000(150000, "内蒙古自治区", "谢美英", "15779780357", 0),
    B210000(210000, "辽宁省", "陈雨馨", "18159366027", 0),
    B220000(220000, "吉林省", "陈雨馨", "18159366027", 0),
    B230000(230000, "黑龙江省", "陈雨馨", "18159366027", 0),
    B310000(310000, "上海市", "蔡杰", "15359056172", 0),
    B320000(320000, "江苏省", "洪亚梨", "18898765039", 0),
    B330000(330000, "浙江省", "陈雨馨", "18159366027", 0),
    B340000(340000, "安徽省", "洪亚梨", "18898765039", 0),
    B350000(350000, "福建省", "洪亚梨", "18898765039", 1),
    B360000(360000, "江西省", "谢美英", "15779780357", 1),
    B370000(370000, "山东省", "陈雨馨", "18159366027", 0),
    B410000(410000, "河南省", "洪亚梨", "18898765039", 0),
    B420000(420000, "湖北省", "洪亚梨", "18898765039", 0),
    B430000(430000, "湖南省", "陈文倩", "15606901429", 0),
    B440000(440000, "广东省", "陈文倩", "15606901429", 0),
    B450000(450000, "广西壮族自治区", "陈晓云", "18596683525", 0),
    B460000(460000, "海南省", "陈文倩", "15606901429", 0),
    B500000(500000, "重庆市", "陈晓云", "18596683525", 0),
    B510000(510000, "四川省", "陈文倩", "15606901429", 0),
    B520000(520000, "贵州省", "谢美英", "15779780357", 0),
    B530000(530000, "云南省", "陈文倩", "15606901429", 0),
    B540000(540000, "西藏自治区", "蔡杰", "15359056172", 0),
    B610000(610000, "陕西省", "林梅香", "18559681023", 0),
    B620000(620000, "甘肃省", "陈晓云", "18596683525", 0),
    B630000(630000, "青海省", "谢美英", "15779780357", 0),
    B640000(640000, "宁夏回族自治区", "陈文倩", "15606901429", 0),
    B650000(650000, "新疆维吾尔自治区", "蔡杰", "15359056172", 0),
    B710000(710000, "台湾省", "", "", 0),
    B810000(810000, "香港特别行政区", "", "", 0),
    B820000(820000, "澳门特别行政区", "", "", 0);

    private Integer code;
    private String province;
    private String businessName;
    private String businessMobile;
    private int active;

    BusinessOwnershipEnum(Integer code, String province, String businessName, String businessMobile, int active) {
        this.code = code;
        this.province = province;
        this.businessName = businessName;
        this.businessMobile = businessMobile;
        this.active = active;
    }

    public Integer getCode() {
        return code;
    }

    public String getProvince() {
        return province;
    }

    public String getBusinessName() {
        return businessName;
    }

    public String getBusinessMobile() {
        return businessMobile;
    }

    public int getActive() {
        return active;
    }

    public static String getMobile(String code){
        for(BusinessOwnershipEnum e : BusinessOwnershipEnum.values()){
            if(e.getCode().toString().equals(code) && e.getActive()==1){
                return e.getBusinessMobile();
            }
        }
        return "";
    }

}
