package com.bcxin.risk.common.util.sms;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.common.util.HttpUtil;
import com.bcxin.risk.common.util.cipher.MD5Util;
import com.bcxin.risk.constant.Const;
import com.bcxin.risk.sys.resources.ConfigResources;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;

@Slf4j
@Component
public class SMSUtil {

	private final static String KEY = "bcxinABCXIN$1012 ";
	private final static String CHANNEL = "pss";

	@Async
	public Future<Boolean> sendSMS(String to, String content){
		//如果是开发环境，屏蔽调用短信接口
		String envi = ConfigResources.PROFILE_ENVI;
		if (Objects.equals(envi,"dev") || Objects.equals(envi,"test")) {
			return new AsyncResult<Boolean>(false);
		}
		String url = ConfigUtil.getValue("sms_url");
		String requestId = System.currentTimeMillis()+"";// 开始时间
		JSONObject json = new JSONObject();
		json.put("type",CHANNEL);
		json.put("content",content);//内容
		json.put("mobile",to);//手机号码
		json.put("requestId",requestId);
		json.put("token", MD5Util.string2MD5(requestId+CHANNEL+KEY));//秘钥
		try {
			String ret = RequestUtil.initHttp().doPost(url, json.toString(), "application/json", "UTF-8");
			JSONObject  retJson = JSONObject.parseObject(ret);
			if (retJson.get("status").equals(Const.HTTP_OK)) {
				log.debug("短信发送成功，手机号：[{}]，短信内容：[{}]",to,content);
				return new AsyncResult<Boolean>(true);
			} else {
				log.error("短信发送失败，手机号：[{}]，短信内容：[{}]",to,content);
				return new AsyncResult<Boolean>(false);
			}
		} catch (Exception ex){
			log.error("短信发送失败，手机号：[{}]，短信内容：[{}]",to,content);
			return new AsyncResult<Boolean>(false);
		}
	}


	@Async
	public Future<Boolean> sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent){
		//如果是开发环境，屏蔽调用短信接口
		String envi = ConfigResources.PROFILE_ENVI;
		//TODO 暂时关闭短信测试环境拦截
		/*if (Objects.equals(envi,"dev") || Objects.equals(envi,"test")) {
			return new AsyncResult<Boolean>(false);
		}*/
		String url = ConfigUtil.getValue("sms_huawei_url");
		List<NameValuePair> params = Lists.newArrayList();
		params.add(new BasicNameValuePair("data", JSON.toJSONString(huaWeiSmsContent)));
		params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.today())));
		HttpUtil.sendPostRequest(url, params);
		log.debug("短信发送成功，手机号：[{}]，短信内容：[{}]",huaWeiSmsContent.getMobile(),huaWeiSmsContent.getParams());
		return new AsyncResult<Boolean>(true);
	}

	public static void main(String[] args) {
		HuaWeiSmsContent huawei = new HuaWeiSmsContent();
		huawei.setParams(JSON.toJSONString(new String[]{"837232"}));
		huawei.setPlatform("BCXIN");
		huawei.setSmsCode("P01");
		huawei.setMobile("18910027675");
		String url = "http://msg.bcxin.com.cn:9165/sms/huawei/sendSMS";
		List<NameValuePair> params = Lists.newArrayList();
		params.add(new BasicNameValuePair("data", JSON.toJSONString(huawei)));
		params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN" + "18910027675" + DateUtil.today())));
		String aa = HttpUtil.sendPostRequest(url, params);
		System.out.println(aa);
	}

}
