package com.bcxin.risk.common.util.compose;

import com.alibaba.fastjson.JSON;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class RestUtil {

	public static String restful(String url, Map<String, String> data) throws IOException {
		URL targetUrl = new URL(url);
		HttpURLConnection httpConnection = (HttpURLConnection) targetUrl.openConnection();
		httpConnection.setDoOutput(true);
		httpConnection.setRequestMethod("POST");
		httpConnection.setRequestProperty("Content-Type", "application/json");
		if(data != null && data.size() > 0) {
			String input = JSON.toJSONString(data);
			OutputStream outputStream = httpConnection.getOutputStream();
			outputStream.write(input.getBytes());
			outputStream.flush();
		}
		if (httpConnection.getResponseCode() != 200) {
			throw new RuntimeException("Failed : HTTP error code : "
			+ httpConnection.getResponseCode());
		}
		BufferedReader responseBuffer = new BufferedReader(new InputStreamReader((httpConnection.getInputStream())));
		String result = "";
		String temp;
		while ((temp = responseBuffer.readLine()) != null) {
			result += temp;
		}
		return result;
	}
	
	public static String restful(String url) throws IOException {
		return restful(url, null);
	}
	
}
