package com.bcxin.risk.common.util.cipher;


public class Sha1Util {

	public static final String HASH_ALGORITHM = "SHA-1";
	public static final int HASH_INTERATIONS = 1024;
	public static final int SALT_SIZE = 8;

	/**
	 * 生成安全的密码，生成随机的16位salt并经过1024次 sha-1 hash
	 */

	public static String entryptPassword(String plainPassword) {
		String plain = Encodes.unescapeHtml(plainPassword);
		byte[] salt = Digests.generateSalt(SALT_SIZE);
		byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, HASH_INTERATIONS);
		return Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword);
	}

	/**
	 * 验证密码
	 *
	 * @param plainPassword
	 *            明文密码
	 * @param password
	 *            密文密码
	 * @return 验证成功返回true
	 */

	public static boolean validatePassword(String plainPassword, String password) {
		String plain = Encodes.unescapeHtml(plainPassword);
		byte[] salt = Encodes.decodeHex(password.substring(0, 16));
		byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, HASH_INTERATIONS);
		return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
	}



//	public static void main(String[] args) {
//		String password ="123456";
//		System.out.println(Sha1Util.entryptPassword(password));
//		String  code="01231fbc436a15e8cdef73db9e37b21db059b0b44cac9d43bf87c570";
//		System.out.println("值是否相同"+Sha1Util.validatePassword(password,code));
//
//	}

    public static void main(String[] args) {
        String str1 = "abcdefghijklmnabc";
        // 从头开始查找是否存在指定的字符
        System.out.println(str1.indexOf("a"));
        // 从第四个字符位置开始往后继续查找
        System.out.println(str1.indexOf("c", 3));
        //若指定字符串中没有该字符则系统返回-1
        System.out.println(str1.indexOf("x"));
    }
}
