package com.bcxin.risk.common.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class TokenUtils {
    private static final String SECRET_KEY = "teemlink_obpm";
    public static final int JWT_REFRESH_TTL = 12 * 60 * 60 * 1000;  //millisecond 7天重新登录的时间间隔
    public static final int JWT_TTL = 1000 * 1000;

    public static String getValueFromToken(String key,String verify){
        try {
            JWTVerifier xxx = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0").acceptExpiresAt(JWT_TTL).build();
            DecodedJWT jwt = xxx.verify(verify);
            String value = jwt.getClaim(key).asString();
            return value;
        } catch (Exception e) {
            return null;
        }
    }

    public static String generateToken(String key,String value) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + JWT_REFRESH_TTL);
            token = JWT.create().withIssuer("auth0").withClaim(key, value).withExpiresAt(expiresAt)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(SECRET_KEY));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return token;

    }

    public static void main(String[] args) {
        String localUser = "18292417675";//local user
//        String localUser = "org_aSuXCEfz";//test user
//        String localUser = "13888888888";//merchant
        String bcxToken = TokenUtils.generateToken("userId",localUser);
        System.out.println(bcxToken);
        String sourceId = TokenUtils.getValueFromToken("sourceId","eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsInN1YiI6IjEyMzQ1IiwiZXhwIjoxNjkzNDc2MDg5fQ.vpYb9E4Gulq8DAJT9-wZ0TsvCsB_1DgrL2GGCMK4ilI");
        System.out.println(sourceId);
    }
}
