package com.bcxin.risk.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JwtUtil {
    /**
     * 数据请求返回码
     */
    public static final int RESCODE_SUCCESS = 1000;				//成功
    public static final int RESCODE_SUCCESS_MSG = 1001;			//成功(有返回信息)
    public static final int RESCODE_EXCEPTION = 1002;			//请求抛出异常
    public static final int RESCODE_NOLOGIN = 1003;				//未登陆状态
    public static final int RESCODE_NOEXIST = 1004;				//查询结果为空
    public static final int RESCODE_NOAUTH = 1005;				//无操作权限

    /**
     * jwt
     */
    public static final String JWT_ID = "blb";
    public static final String JWT_SECRET = "18disdkfd83DPQ012I8VcnSkq"; //私钥
    //	public static final int JWT_TTL = 24*60*60*1000;  //millisecond 1天 客户端去申请token
    public static final int JWT_TTL = 365*24*60*60*1000;  //millisecond 1天 客户端去申请token
    public static final int JWT_REFRESH_INTERVAL = 55*60*1000;  //millisecond token无效的时间间隔
    public static final int JWT_REFRESH_TTL = 7*24*60*60*1000;  //millisecond 7天重新登录的时间间隔
    private static final String JWT_SECRET_WSK = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";


    /**
     * 由字符串生成加密key
     * @return
     */
    private static SecretKey generalKey(String stringKey){
//        String stringKey = JwtUtil.JWT_SECRET;
        byte[] encodedKey = Base64.decodeBase64(stringKey);
        SecretKey key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    /**
     * 创建jwt，ttlMillis为负数表示不过期
     * @param id
     * @param subject
     * @param ttlMillis
     * @return
     * @throws Exception
     */
    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
                .setId(id)
                .setIssuedAt(new Date(System.currentTimeMillis()))
                .setSubject(subject)
                .signWith(signatureAlgorithm, generalKey(stringKey));
        if (ttlMillis >= 0) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }
    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWT(Map<Object,Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
//				.setId(JwtUtil.JWT_ID) // 暂时不用，减少流量
//				.setIssuedAt(new Date(System.currentTimeMillis())) //发行时间  暂时不用，减少流量
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(stringKey)); //选择的算法，和私钥值
        if (ttlMillis >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    /**
     * 解密jwt
     * @param jwttoken
     * @return
     * @throws Exception
     */
    public static Claims parseJWT(String jwttoken, String stringKey) throws Exception {
        Claims claims = Jwts.parser()
                .setSigningKey(generalKey(stringKey)) //没有私钥是解密不了的
                .parseClaimsJws(jwttoken).getBody();
        return claims;
    }

    public static Claims parseJWT(String jwttoken) throws Exception {
        Claims claims = Jwts.parser()
                .setSigningKey(generalKey(JWT_SECRET_WSK)) //没有私钥是解密不了的
                .parseClaimsJws(jwttoken).getBody();
        return claims;
    }

    //加密
    public static String encrypting(Map<Object,Object> map){
        String jwt_secret = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";//百宝盾平台固定私钥
//        String token = "eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7XCJ1c2VyaWRcIjoxMzkzfSIsImV4cCI6MTUwNjE1NDMxMX0.xBl9vnusKOIYl0xYQHGOSMv05nSYqZGjJcCiveFB_CE";//加密生成token
        String token = JwtUtil.createJWT(map,jwt_secret,JwtUtil.JWT_REFRESH_TTL);//加密生成token
        return  token;
    }

    public static void main(String[] args) throws Exception  {

        Map<Object,Object> p = new HashMap<Object,Object>();
        //p.put("platform", "pss");//模拟数据
        //p.put("serialNumber", "sn41d12423e32238");//模拟数据
        //p.put("resume", "1");//模拟数据
        //// http://www.pss360.cn/getResource.do?path=shanxi/2017-10-24/hd/_act_100197_t_20171024044123.zip
//        p.put("fileUrl","http://bcxinsaasprod.baibaodun.cn/upload%2F2020-09-17%2F1600321761581057528.docx");//模拟数据
        //p.put("way", "2");//模拟数据
        //p.put("how", "1");//模拟数据
        //p.put("callback", "http://localhost:8888/response");//模拟数据
        //p.put("extra", "我是附带信息");//模拟数据
        //
        String jwt_secret = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr"; //固定私钥，测试生产均为同一个
        String token = JwtUtil.createJWT(p,jwt_secret,JwtUtil.JWT_REFRESH_TTL);//加密生成token

        Map<String,Object> requestMap = Maps.newHashMap();
        requestMap.put("token",token);
        JwtUtil.parseJWT("eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7fSIsImV4cCI6MTY2OTg4NTU0OH0.EL7ZHkQK3f5IAOlsn7_PI4wLO2G26arlCTgMYvROWLg");
        System.out.println(token);
    }

    /**
     * 创建jwt
     * @param subject
     * @return
     */
    public static String createJWT(Map<String,String> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder()
//				.setId(JwtUtil.JWT_ID) // 暂时不用，减少流量
//				.setIssuedAt(new Date(System.currentTimeMillis())) //发行时间  暂时不用，减少流量
                .setSubject(JSON.toJSONString(subject)) //主题，就是附带在token中的信息
                .signWith(signatureAlgorithm, generalKey(JWT_SECRET_WSK)); //选择的算法，和私钥值
        if (JWT_REFRESH_TTL >= 0) { //如果过期时间为负数，那么不设置过期时间
            long expMillis = System.currentTimeMillis() + JWT_REFRESH_TTL;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String setIDJwt(String id){
        Map<Object,Object> p = new HashMap<Object,Object>();
        p.put("oid", id);
        return JwtUtil.createJWT(p,JWT_SECRET_WSK,30*1000);
    }

    public static JSONObject getBody(String token) throws Exception {
        Claims claims = parseJWT(token);
        String sub = (String)claims.get("sub");
        return JSONObject.parseObject(sub);
    }

}
