package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.sys.SysBasicUtil;
import com.bcxin.risk.sys.resources.ConfigResources;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.mail.*;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;

@Component
@Slf4j
public class EmailUtil {

    private static String mail_bcxHead ="<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>百川信提醒邮件</title><style type=\"text/css\">body,ul,li,p,h2 { margin:0; padding:0; }body { background-color:#f9f9f9; }.clear{clear:both;}li {list-style:none;}#box {width:702px; height:100%; margin:0 auto;}.header {width:702px;}.main { width:700px; background:#FFF; border:1px solid #d8d8d8; border-top:none;}.main .main_a {width:624px; padding:26px 0 0 30px;}.main .main_a h2 {font-family:\"微软雅黑\"; font-size:16px; color:#f68239; letter-spacing:1px;}.main .main_a p {width:624px; padding-top:10px; font-size:12px; color:#555; line-height:20px; letter-spacing:1px; text-indent:2em; }.main_b {width:622px; height:128px; background:#f8f8f8; border:1px solid #ed999f; margin:20px 0 0 30px;}.main_b p {font-size:12px; color:#2e1402; line-height:20px; letter-spacing:1px; padding:5px 0 0 30px;}.main_c {width:700px; height:32px; background:#b29e6b; margin:20px 0 0 0;}.main_c p {font-family:\"微软雅黑\"; font-size:14px; color:#FFF; text-align:center; line-height:32px; letter-spacing:1px;}.main_d {width:678px;}.main_d ul li {float:left; padding:30px 0 0 50px;}.main_e { margin-top:30px;  border-top:1px solid #D8D8D8;  margin-bottom:1px;}.main_e img {width:675px; height:112px; margin:2px 0 0 1px;}.footer {width:702px; height:4px; background:#bcbcbc; margin-bottom:20px; }</style></head><body><div id=\"box\"><div class=\"header\"><img src=\"http://www.bcxin.com.cn/resources/images/mail-bcx_r1_c1.jpg\" usemap=\"#Map\" border=\"0\" /><map name=\"Map\" id=\"Map\"><area shape=\"rect\" coords=\"16,10,192,81\" href=\"http://www.pss360.cn\" /></map></div><div class=\"main\"><div class=\"main_a\">";
    private static String mail_bcxFooter = "</div><div class=\"main_b\"><p style=\"margin-top:10px;\">选择更多保险产品请登录百川信（www.bcxin.com.cn）查询。</p><p>如有任何疑问，请联系百川信在线客服或拨打客服热线：400-662-9696（24小时为您服务）。</p><p>电子邮箱：bcxin@bcxin.com.cn</p><p>该邮件由百川信系统发出，请勿直接回复。</p></div><div class=\"main_c\"><p>更多精彩内容</p></div></div> <div class=\"footer\"></div></div></body></html>";


    //发送信件邮箱的用户名及密码
    private static String username;
    private static String password;

    //邮件服务器设置
    private static String host;
    private static String from;

    private final static ResourceBundle config = ResourceBundle.getBundle("config/config");

    /*
     * 初始化方法
     */
    public EmailUtil() {
        host = config.getString("mail_host");
        username = config.getString("mail_from");
        password = config.getString("mail_password");
        from = config.getString("mail_from");
    }

    
    /**
     * 发送邮件
     * 
     * @param subject
     *            邮件主题
     * @param body
     *            邮件内容
     * @param to
     *            收件人地址
     *            附件
     */
    @Async
    public void sendEmail(String subject, String body, String to) {
        //如果是开发环境，屏蔽调用邮件接口
        if (Objects.equals(ConfigResources.PROFILE_ENVI,"dev")) {
            return;
        }
        if (StringUtil.isEmpty(to)) {
            return;
        }
        if (!to.matches("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+")) {
            log.error("邮箱（"+to+"）校验未通过，格式不对!");
            return;
        }
        try {

            final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";

            // 创建信件服务器
            Properties props = System.getProperties();
            props.setProperty("mail.smtp.host", host);
            props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", "465");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.put("mail.smtp.auth", "true");
            // 得到默认的对话对象
            Authenticator a = new Authenticator() {
                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            };
            //创建Session实例
            Session session = Session.getDefaultInstance(props, a);
            //创建MimeMessage实例对象
            MimeMessage msg = new MimeMessage(session);

            //设置自定义发件人昵称
            String nick = "";
            try {
                nick = javax.mail.internet.MimeUtility.encodeText(SysBasicUtil.getConfig("platform_name"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            //设置发信人
            msg.setFrom(new InternetAddress(nick + " <" + from + ">"));
            //设置收信人
            msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
            //设置发送日期
            msg.setSentDate(new Date());
            //设置邮件主题
            msg.setSubject(subject);
            //设置邮件正文
            msg.setText(body);
            Transport.send(msg);

            log.debug("邮件发送成功，收件人[{}]，主题[{}]，发送内容[{}]",to,subject,body);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("邮件发送失败，收件人[{}]，主题[{}]，发送内容[{}]",to,subject,body);
            log.error("邮件发送失败，异常[{}]",e.getMessage());
        }
    }

}
