package com.bcxin.risk.common.util;

import com.bcxin.risk.sys.resources.ConfigResources;

import java.sql.*;

public final class DbUtil {

    /**
     * 数据库连接
     */
    public static Connection getMySqlConn() throws SQLException {
        return DriverManager.getConnection(ConfigResources.JDBC_URL, ConfigResources.JDBC_USERNAME, ConfigResources.JDBC_PASSWORD);
    }

    /**
     * 释放数据库连接
     */
    public static void free(ResultSet rs, PreparedStatement ps, Connection conn) {
        try {
            if (rs != null) {
                rs.close();
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            } catch (SQLException e) {
                e.printStackTrace();
            } finally {

                try {
                    if (conn != null) {
                        conn.close();
                    }
                } catch (SQLException e) {
                    e.printStackTrace();
                }

            }

        }

    }

    /**
     * 加载mysql驱动
     */
    static {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        } catch (ClassNotFoundException e) {
            System.out.println("驱动加载出错");
        }
    }

}