/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.order.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.constants.GlobalConstants;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.common.mapper.JsonMapper;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.core.service.SysUserService;
import com.bcxin.models.order.dao.OrderFormDao;
import com.bcxin.models.order.entity.OrderForm;
import com.bcxin.models.order.entity.OrderPayment;
import com.bcxin.models.order.service.OrderCompanyRelationService;
import com.bcxin.models.order.service.OrderFormService;
import com.bcxin.models.order.service.OrderPaymentService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.mapper.Wrapper;
import com.bcxin.spring.http.HttpService;
import com.bcxin.util.toolbox.DateUtil;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${apiPath}/webOrderForm"})
public class OrderFormApiController
extends BaseController {
    @Autowired
    private SysCompanyService sysCompanyService;
    @Autowired
    private OrderFormService orderFormService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private OrderPaymentService orderPaymentService;
    @Autowired
    private OrderCompanyRelationService orderCompanyRelationService;
    @Autowired
    private HttpService httpService;
    @Autowired
    private OrderFormDao orderFormDao;
    private static final Logger log = LoggerFactory.getLogger(OrderFormApiController.class);
    public static final String HXXY_GET_FEE_URL = GlobalConstants.getConfig((String)"HXXT") + "/api/getPSSAgreement";

    @RequestMapping(value={"/getPSSSupplyProduct"})
    @ResponseBody
    public AjaxResult getPSSSupplyProduct(String ywzcId, String riskType, String province, String city, String area) {
        AjaxResult ajaxResult = new AjaxResult(true);
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("companyId", ywzcId);
            map.put("riskType", riskType);
            map.put("province", province);
            map.put("city", city);
            map.put("area", area);
            List list = this.sysCompanyService.findPSSSupplyProduct(map);
            ajaxResult.setData((Object)list);
            return ajaxResult;
        }
        catch (Exception e) {
            ajaxResult.setMessage(e.getMessage());
            ajaxResult.setSuccess(false);
            return ajaxResult;
        }
    }

    @RequestMapping(value={"/getFeeRate"})
    @ResponseBody
    public AjaxResult getFeeRate(String ywzcId, String productId, String province, String city, String area) {
        AjaxResult ajaxResult = new AjaxResult(true);
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("companyId", ywzcId);
            map.put("productId", productId);
            map.put("province", province);
            map.put("city", city);
            map.put("area", area);
            String result = this.httpService.doPost(HXXY_GET_FEE_URL, map);
            ajaxResult = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
            return ajaxResult;
        }
        catch (Exception e) {
            ajaxResult.setMessage(e.getMessage());
            ajaxResult.setSuccess(false);
            return ajaxResult;
        }
    }

    @RequestMapping(value={"/receiveExportData"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public AjaxResult receiveExportData(@RequestParam Long risk_activity_id, @RequestParam Long export_id, @RequestParam Long product_id, @RequestParam String project_name, @RequestParam String step) {
        log.info("\u4e13\u5bb6\u6570\u636e\u5bf9\u63a5\u5f00\u59cb\uff1a------------" + export_id);
        log.info("\u4e13\u5bb6\u6570\u636e\uff1a------------\uff1ariskActivityID:" + risk_activity_id + ",productID\uff1a" + product_id + ",project_name\uff1a" + project_name + ",export_id\uff1a" + export_id + ",step\uff1a" + step);
        if (!(StrUtil.isEmpty((String)step) || "null".equals(export_id) || "".equals(export_id))) {
            if (this.orderFormService.selectByRiskActivityIDAndProductID(risk_activity_id, product_id, export_id, step) < 1) {
                log.info("\u4e13\u5bb6\u6570\u636e\u67e5\u91cd\u7ed3\u675f\uff0c\u6ca1\u6709\u91cd\u590d\u6570\u636e\uff1a------------" + export_id);
                boolean rs = this.orderFormService.updataExportOrderFrom(risk_activity_id, export_id, product_id, project_name, step);
                if (!rs) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return new AjaxResult(false, "\u4e0d\u5b8c\u5168\u4fdd\u5b58\uff0c\u8bf7\u6c42\u5931\u8d25");
                }
                log.info("\u4e13\u5bb6\u6570\u636e\u5bf9\u63a5\u7ed3\u675f\uff1a------------" + export_id);
                return new AjaxResult(true, "\u4e13\u5bb6\u8ba2\u5355\u63a5\u53e3\u64cd\u4f5c\u6210\u529f");
            }
            log.info("\u9519\u8bef\uff1a\u8ba2\u5355\u6570\u636e\u91cd\u590d\uff1ariskActivityID:" + risk_activity_id + ",productID\uff1a" + product_id + ",export_id\uff1a" + export_id + ",step\uff1a" + step);
            return new AjaxResult(false, "\u8ba2\u5355\u6570\u636e\u91cd\u590d\uff1ariskActivityID:" + risk_activity_id + ",productID\uff1a" + product_id + ",export_id\uff1a" + export_id + ",step\uff1a" + step);
        }
        log.info("\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a\uff1ariskActivityID:" + risk_activity_id + ",productID\uff1a" + product_id + ",export_id\uff1a" + export_id + ",step\uff1a" + step);
        return new AjaxResult(false, "\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a\uff1ariskActivityID:" + risk_activity_id + ",productID\uff1a" + product_id + ",export_id\uff1a" + export_id + ",step\uff1a" + step);
    }

    @RequestMapping(value={"/receiveOrderFormData"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult receiveOrderFormData(OrderForm orderForm, String activity_id) {
        String msg;
        log.info("\u8ba2\u5355\u540c\u6b65\u53c2\u6570DDTBCS\uff1a" + JSON.toJSONString((Object)orderForm));
        List activity = this.orderFormDao.getActivityInfoById(activity_id);
        if (activity.size() > 0) {
            orderForm.setProjectName(String.valueOf(((Map)activity.get(0)).get("activity_name")));
        }
        if (orderForm != null && StrUtil.isNotBlank((CharSequence)(msg = this.beanValidatorAPI(orderForm, new Class[0])))) {
            return this.fail(false, msg);
        }
        List list = this.orderFormService.selectList(new EntityWrapper().addFilter("web_order_form_id={0} and sign={1}", new Object[]{orderForm.getWebOrderFormId(), orderForm.getSign()}));
        if (null != list && list.size() > 0) {
            return new AjaxResult(true, "\u8be5\u8ba2\u5355\u5df2\u7ecf\u5b58\u5728!", (Object)StrUtil.obj2Str((Object)((OrderForm)list.get(0)).getId()));
        }
        OrderPayment orderPayment = orderForm.getOrderPayment();
        orderPayment.setOrderFormId(Long.valueOf(0L));
        if (orderPayment != null) {
            msg = this.beanValidator(orderPayment, new Class[0]);
            if (StrUtil.isNotBlank((CharSequence)msg)) {
                return this.fail(false, msg);
            }
        } else {
            return this.fail(false, "\u652f\u4ed8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.orderFormService.saveOrderFormOrPayment(orderForm, orderPayment);
        return new AjaxResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)StrUtil.obj2Str((Object)orderForm.getId()));
    }

    @RequestMapping(value={"/receiveOrderPaymentData"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult receiveOrderFormData(OrderPayment orderPayment) {
        String msg;
        if (orderPayment != null && StrUtil.isNotBlank((CharSequence)(msg = this.beanValidator(orderPayment, new Class[0])))) {
            return this.fail(false, msg);
        }
        int count = this.orderFormService.selectCount((Wrapper)new EntityWrapper((Object)new OrderForm(orderPayment.getOrderFormId())));
        if (count < 1) {
            return this.fail(false, "\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        this.orderFormService.saveOrderFormOrPayment(null, orderPayment);
        return new AjaxResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)StrUtil.obj2Str((Object)orderPayment.getOrderFormId()));
    }

    @RequestMapping(value={"/cancellationOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult cancellationOrder(@RequestParam Long orderFormId, @RequestParam String sign) {
        int count = this.orderFormService.selectCount((Wrapper)new EntityWrapper((Object)new OrderForm(orderFormId)));
        if (count < 1) {
            return this.fail(false, "\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return this.fail(true, "\u64a4\u5355\u6210\u529f");
    }

    @RequestMapping(value={"/queryOrderFormList"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult queryOrderFormList(@RequestParam String webUserId, @RequestParam String sign) {
        OrderForm orderForm = new OrderForm();
        orderForm.setWebUserId(webUserId);
        orderForm.setSign(sign);
        List list = this.orderFormService.selectList((Wrapper)new EntityWrapper((Object)orderForm));
        return new AjaxResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)list);
    }

    @RequestMapping(value={"/getOrderFormHXXT"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getOrderFormHXXT(String startDate) {
        HashMap params = Maps.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)startDate)) {
            params.put("startDate", startDate);
        }
        List orderFormList = this.orderFormService.selectToHxxt((Map)params);
        return this.json(true, StrUtil.formatDate((List)orderFormList));
    }

    @RequestMapping(value={"/getOrderFormPaymentHXXT"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getOrderFormPaymentHXXT(String startDate) {
        HashMap params = Maps.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)startDate)) {
            params.put("startDate", startDate);
        }
        List orderPaymentList = this.orderPaymentService.selectToHxxt((Map)params);
        return this.json(true, StrUtil.formatDate((List)StrUtil.formatDate((List)orderPaymentList)));
    }

    @RequestMapping(value={"/getOrderFormCompanyHXXT"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult getOrderFormCompanyHXXT(String startDate) {
        HashMap params = Maps.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)startDate)) {
            params.put("startDate", startDate);
        }
        List orderPaymentList = this.orderCompanyRelationService.selectToHxxt((Map)params);
        return this.json(true, orderPaymentList);
    }

    @RequestMapping(value={"/receiveOrderFormExpertData"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult receiveOrderFormExpertData(HttpServletRequest request) {
        String data = request.getParameter("orderFormData");
        if (StrUtil.isBlank((String)data)) {
            return this.fail(false, "\u6ca1\u6709\u63a5\u6536\u5230\u6570\u636e");
        }
        List list = (List)JsonMapper.fromJsonString((String)data, List.class);
        if (list != null) {
            this.expertOrderData(list);
        }
        return new AjaxResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)list.size());
    }

    private void expertOrderData(List<Map<String, Object>> list) {
        for (Map<String, Object> o : list) {
            this.orderCompanyRelationService.saveExpertOrder(o);
        }
    }

    @RequestMapping(value={"/test"})
    public void test() {
        OrderForm orderForm = new OrderForm();
        orderForm.setCity("350100");
        orderForm.setCurrency("CNY");
        orderForm.setDistributorId("943068372292505602L");
        orderForm.setDistrict("0");
        orderForm.setEndDate(DateUtil.parseDate((Object)"2018-12-20"));
        orderForm.setFcy(new BigDecimal("0.01"));
        orderForm.setInvoiceType("1");
        orderForm.setOrderDate(DateUtil.parseDate((Object)"2017-12-20 15:10:05"));
        orderForm.setOrderNumber("TEST2-7708120171220");
        orderForm.setProductId(Long.valueOf(871284565591744512L));
        orderForm.setProvince("350000");
        orderForm.setSign("STS");
        orderForm.setStagesNumber("1");
        orderForm.setStartDate(DateUtil.parseDate((Object)"2017-12-20"));
        orderForm.setWebOrderFormId("TEST2-770812017122120");
        orderForm.setWebUserId("0");
        orderForm.setPaymentMethod("1");
        OrderPayment payment = new OrderPayment();
        payment.setActualPayment(new BigDecimal("0.01"));
        payment.setCurrentPayable(new BigDecimal("0.01"));
        payment.setPayDate(DateUtil.parseDate((Object)"2017-12-12 17:32:14"));
        payment.setPaySerialNumber("770812017121220");
        payment.setPaymentMethod(Integer.valueOf(3));
        payment.setRemainingNumber(Integer.valueOf(1));
        orderForm.setOrderPayment(payment);
    }
}

