<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace crmeb\utils;

/**
 * 正则表达式
 * Class Regex.
 */
class Regex
{
    // 银行卡号
    public const BANK_NUMBER = '/^((103)\\d{16}|(9558|9111)\\d{15}|(95595|95596|95597|95598|95599|65)\\d{14}|(623529|622181|955100|621095|621798|621799|621797|620062|621285|622150|622151|622199|621096|622188|623218|621599|623698|623699|623686|621098|622180|622182|622187|622189|623676|623677|621674|622183|621622|621582|623219|620529|900000|621226|620516|621721|900010|621288|620086|621670|621225|621227|621281|622200|622202|622203|622208|621218|621476|623229|620058|621618|623260|623271|623272|621558|621559|621722|621723|621475|623062|621720|621379|620114|620146|621240|621724|621762|621414|621375|620187|622926|622927|622928|622929|622930|622931|621733|621732|621719|621369|621763|620046|623206|621671|620059|621282|621336|621619|622821|622822|622823|622824|622825|622826|622827|622828|622840|622841|622843|622845|622846|622848|622849|623018|623050|623053|623052|622844|622847|623056|620501|621667|621212|621283|620061|620040|621330|621331|621297|621620|621757|621672|623571|623572|623184|623586|623573|621665|627026|627028|627025|627027|621332|621333|621660|621661|621662|456351|601382|621256|621568|621569|621663|621666|621668|621669|621725|621756|621758|621759|621785|621786|621787|621788|621789|621790|623208|623263|623569|623575|622771|622772|622770|620531|622273|622274|620513|621284|436742|589970|620060|621081|621467|621621|621700|622280|622700|621598|621673|623211|623668|623094|623669|623656|623644|627020|620525|620021|620521|622261|622260|622262|623560|623261|623191|621069|621436|621002|621335|620527|622999|303|620535|621462|685800|620037|623506|623259|622568|620520|623078|621019|622309|623269|622933|622938|623031|623625|621016|621015|623187|621060|623551|621072|623630|621213|621290|621291|621292|623555|621289|621328|623176|621651|623163|623526|623565|623633|623622|623632|627061|627076|623019|621600|623514|623663|623561|623562|623283|623533|622865|623131|621418|620533|623252|622379|940008|621626|623058|622338|623205|623511|623112|623578|603445|622467|940016|621463|622455|940039|623118|623151|622993|623070|623069|623172|623173|603506|622499|940046|623000|622498|623582|621439|623010|623278|621751|621754|622143|940001|621532|621482|622135|622152|622153|622154|622996|622997|940027|622442|623099|623007|940066|622359|623531|622421|621417|623089|623200|621529|622429|622363|940048|621455|623119|623568|622877|622879|623291|621775|623203|623096|622425|621577|622133|622170|621735|621552|888|623098|621242|621496|623129|621538|623541|623275|621216|623179|621419|623170|620551|69580|622307|622162|623146|623077|622857|940065|621237|623003|623039|940071|621446|622368|620519|621739|622967|940073|623127|622370|621437|623177|621415|621480|622147|621633|623057|622301|623171|621266|621422|623592|623631|623102|622342|623048|622367|622392|623085|622395|622925|623595|622982|621413|621562|621097|621588|622644|623032|623518|623216|621037|622897|623072|623285|621403|622561|622562|622563|623137|623264|622167|623193|623197|622532|621076|622131|622876|622873|621579|623279|622173|623509|622936|623060|622937|623101|623286|622980|623135|621726|621088|620517|622972|623196|623083|622973|623153|623121|621070|622977|622978|623093|621200|623116|621038|623180|621086|621498|623290|621448|621296|621551|621044|623120|622940|621089|623161|621029|621766|623139|621071|623152|621074|621515|623030|621090|623178|621091|623168|621238|621057|623199|621233|623588|621223|621780|621239|623068|621273|623079|621325|623084|621366|621388|621348|620063|621360|623566|622959|623076|621391|621339|621469|621625|623113|623627|623293|623665|623688|621655|623537|621636|623182|623087|621696|623577|621460|621461|622855|623521|623138|621221|621748|622979|623037|623160|621035|621075|621271|621327|621337|621601|621753|623621|621688|623162|623552|622443|623132|940029|623071|603694|622323|621017|623190|940062|623038|622328|622184|621251|621589|623036|622127|621701|621560|621068|620088|621067|621066|622138|622531|622329|623103|623539|622343|621516|622345|623088|622452|621578|622324|623066|623267|622858|621058|621527|623091|621537|621736|623540|622869|623075|622882|621779|621590|622893|623090|621519|621539|622169|622681|622682|622683|623013|621021|622358|623025|623501|621566|622506|623027|623028|622992|623133|622935|621531|623181|623618|622947|621561|623095|621526|622953|621036|621458|621536|622509|621518|621728|622362|622470|622477|622510|621018|622859|621737|621533|621362|622976|621033|621099|621457|621459|621530|623201|623256|621061|621520|623065|621026|621449|622968|621280|621580|623051|621073|623109|623516|621228|621557|621361|623033|623207|621363|622891|623189|623576|623510|623603|623673|623628|623659|627070|623662|627060|621053|621230|621229|621481|621389|622943|623318|621411|621443|622409|621441|623107|622463|621087|621741|621782|623309|621743|621783|623308|621742|621784|623310|622547|622548|622546|620072|622434|622436|622435|644|621253|621254|621255|621344|621274|621324|620126|620537|623459|623477|921001|921002|620550|620559|921000|621563|620038|603367|623664|621752|621246|621727|623128|621778|621550|623220|623637|620528|623212)\\d{13}|(6201365|6201366|6201367|6201368|6201369|6230745|6230746|6230747|6230748|6230749|6235244|6235245|6235246|6235248|6251648|6251649|6258248|6258249|6230744|6235247|6201360|6235240|6230440|620200|620302|620402|620403|620404|620406|620407|620409|620410|620411|620412|620502|620503|620405|620408|620512|620602|620604|620607|620611|620612|620704|620706|620707|620708|620709|620710|620609|620712|620713|620714|620802|620711|620904|620905|620902|621103|621105|621106|621107|621102|621203|621204|621205|621206|621207|621208|621209|621210|621302|621303|621202|621305|621306|621307|621309|621311|621313|621211|621315|621304|621402|621404|621405|621406|621407|621408|621409|621410|621502|621317|621511|621602|621603|621604|621605|621608|621609|621610|621611|621612|621613|621614|621615|621616|621607|621606|621804|621807|621813|621814|621817|621901|621904|621905|621906|621907|621908|621909|621910|621911|621912|621913|621915|621903|622004|622005|622006|622007|622008|622010|622011|622012|621914|622015|622016|622018|622019|622102|622103|622104|622105|622013|622111|622114|622017|622110|622303|622304|622305|622306|622307|622308|622314|622315|622317|622302|622402|622403|622404|622313|622504|622505|622509|622513|622517|622502|622604|622605|622606|622510|622715|622806|622902|622706|623002|623006|623008|623011|623012|622904|623015|623100|623202|623301|623400|623602|623803|623901|623014|624100|624200|624301|624402|623700|624000|621001|621617|622002|622003|622020|622309|622703|622903|623500|553242|6858000|6858001|6858009|690755|966666|622909|622908|438588|438589|621298|623616|623661|623183|623185|621005|622172|622985|622987|622267|622278|622279|622468|622892|940021|621050|620522|621243|620041|621267|620043|623063|621664|990027|566666|603367|622878|623061|623209|603602|940053|621452|622331|623554|623574|940015|9896|940049|622981|623165|622136|623277|622485|621359|940017|694301|683970|940074|990871|622126|623166|622292|622291|621412|622960|623523|623653|621004|623130|623167|621345|621263|623080|621217|621270|621235|6224217|623667|9400301|909810|940035|621522|622439|623257|940037|622271|18572|940042|622991|621585|623013|623059|621392|621310|6506|6507|6508|6509|6234153|6234300|6234390)\\d{12}|(6201363|6230743|6235243|6251647|6258247|62926030|62926031|62926032|62926033|62926034|62926035|62926036|62926037|62926038|62926039|62926918|62926919|62926920|62926921|62926922|62926923|62926040|62926041|62926042|62926043|62926044|62926045|62926046|62926047|62926048|62926049|62926924|62926925|62926926|62926927|62926928|62926929|62926100|62926050|62926103|62926104|62926105|62926106|62926107|62926051|62926113|62926114|62926115|62926930|62926931|62926932|62926933|62926934|62926935|62926936|62926937|62926938|62926939|62926940|62926941|62215049|62215050|62215051|62218849|62218850|62218851|62326597|62329906|45806|53098|49102|53591|62329901|5453242|5491031|5544033|53242|53243|62364330|62364331|62364332|62329902|62153403|405512|601428|622259|62844808|622258|90030|62364873|95555|62326536|90592|623287|84380|84342|84385|84301|84336|84361|84373|84390|87000|87010|87030|87040|87050|622384|940034|62326528|62053803|62329900|62318799|62326603|62326594|62317622|62317633|62326516|62704300|62326584|62364305|62364306|62364307|62364312|62364308|62364310|62364309|62364316|62360066|62364323|6886592|62326580|62326575|62704309|62326531|940041|622420|622399|940043|603708|62326568|62326527|62326535|622442|62326555|62153402|940055|6091201|940056|96828|62326540|62326574|940057|622311|622990|940003|603601|622137|622327|622340|622366|622425|62326501|62326519|62364320|62326533|940006|622465|940031|62326538|62704307|62153405|62249802|94004602|622310|940068|623599|623670|940069|62326529|622400|62326582|622308|62326552|62326512|62326525|62329905|62704302|62249804|94004604|62326559|622336|621760|623273|62326571|62326599|621456|622856|623221|62326545|62326503|62326526|62326558|622962|62326515|62704305|62326587|62326602|62364303|62326564|622396|622511|62326610|62326530|62326523|622939|62326542|62326565|62364300|62326586|62326508|62326577|940044|62326583|62326591|62326561|622332|940063|623123|62326562|62326520|62326590|62326573|62153401|62326566|62326550|62326537|62326539|62704304|62153404|62326601|62326502|62326578|62105600|62359701|62355603|62355602|62355601|62359704|62359703|62359702|62109209|62109207|62109202|62109203|62109208|62109211|62109205|62109210|62109212|62109206|62109214|62109215|62109213|621308|621219|62134615|62134614|62134617|62134616|62134605|62134608|62134620|62134603|62134604|62134609|62134622|62134621|62134602|62134601|62134613|62134625|62134611|62134624|62134606|62134626|62134607|62134618|62134619|62134627|62134623|62140101|62163751|62163743|62163723|62163728|62163727|62163724|62163725|62163750|62308299|62319801|62319806|62319802|62319803|62309702|62309701|62165666|62165932|62169301|62169302|62169303|62169502|62169505|62169501|62169507|62169503|62169504|62169506|62352801|62311702|62312201|62317502|62317501|62138501|62316904|62316905|62316902|62316903|62316901|62316906|62138402|62138404|62138403|62138401|62138407|62138405|62138408|62138406|62138409|62138410|62360636|62360637|62360634|62360630|62360632|62360631|62360633|62360635|62360638|62360602|62360603|62360629|62360625|62360626|62360628|62360627|62360601|62360620|62360622|62360624|62360623|62360621|62360600|62360607|62360608|62360605|62360604|62360606|62360609|62360612|62360613|62360610|62360614|62360615|62360616|62360611|62360617|62360618|62360619|62350801|62109216|62351501|62168305|62168301|62168304|62168302|62168309|62168308|62168306|62168303|62168307|62352501|62352700|62352702|62352701|62314911|62314907|62314903|62314906|62314909|62314902|62314901|62314910|62314908|62314905|62357012|62357017|62357009|62357022|62357021|62357015|62357013|62357010|62357014|62357006|62357002|62357008|62357011|62357007|62357016|62357004|62357003|62357018|62357001|62357005|62357019|62357020|62314701|62358101|62358303|62358301|62358302|62361702|62361703|62361701|62143801|62143802|62006401|62300401|62310402|62310401|62364201|62363500|62361902|62361901|62362401|62365003|62365002|62365001|62365005|62365006|62365007|62365008|62365011|62365010|62365009|62359602|62359601|62359606|62359607|62359603|62359605|62707305|62707301|62707302|62707306|62707308|62707303|62707307|62707304|62165203|62165202|62165201|62165204|62304701|62365401|62365227|62365225|62365229|62365226|62365202|62365228|62365220|62365213|62365224|62365217|62365221|62365215|62365218|62365223|62365222|62365214|62365216|62365211|62365219|62365210|62365212|62365203|62365204|62365205|62365208|62365209|62365206|62365207|62365504|62365502|62365501|62365503|62365506|62365507|62365701|62311401|62311402|62354903|62354902|62367201|62134612|62367401|62364001|62364602|62364607|62364603|62364608|62364605|62364604|62364601|62364606|62368401|62368701|62363801|62367502|62367503|62367501|62706401|62706501|62367901|62147000|62707501|62353400|62315402|62315401|62315403|62315404|62177400|62177403|62177404|62177402|62354702|62354701|62354700|62313401|62313403|62313400|62313402|62316401|62316400|62704114|62704101|62704000|62704001|62704003|62704002|62707503|62707508|62707507|62704201|62704203|62704205|62704202|62704200|62704204|62707505|62707504|62707517|62707519|62707510|62707512|62707521|622365|622375|622489|622487|622490|622491|622492|621744|621745|621746|621747|622971|622970|623497|621442|622410|621440|623106|622459|623328|623397|623465|62911022|60110|60112|60113|60114|60119|62911054|62911055|62341550|62340800|62921000|62921001|62925200|62911029|62917901|62921002|62913610|62911200|62911052|62911053|62909503|62911063|62909504|62911506|62053801|62053802|62053804|62326551|62911015|62326612|62707506|62911700)\\d{11}|(620035|622789|621638|621334|625140|621395|622725|622728|421349|434061|434062|436728|453242|491031|524094|526410|544033|552245|621080|621466|621488|621499|622707|622966|622988|625955|625956|621082|623251|436742193|622280193|356896|356899|356895|436718|436738|436745|436748|489592|531693|532450|532458|544887|552801|557080|558895|559051|622166|622168|622708|625964|625965|625966|628266|628366|625362|625363|628316|628317|434910|458123|458124|520169|522964|622250|622251|521899|622254|622255|622257|622253|622656|628216|622252|955590|955591|955592|955593|628218|491040|537839|625138|622256|622284|622285|620013|625028|625029|433670|433680|442729|442730|620082|622690|622691|622692|622696|622698|622998|433671|968807|968808|968809|621771|621767|621768|621770|621772|621773|621769|623280|622662|622663|622664|622665|622666|622667|622669|622670|622671|622672|622668|622661|622674|622673|620518|621489|621492|623156|621490|621491|620085|623155|623157|623158|623159|623253|622660|999999|623020|623021|623022|623023|622630|622631|622632|622633|623292|620552|621222|622615|622616|622618|622622|622617|622619|415599|421393|421865|427570|427571|472067|472068|622620|621691|900003|623683|621692|623255|623258|545392|545393|545431|545447|356859|356857|407405|421869|421870|421871|512466|356856|528948|552288|622600|622601|622602|517636|622621|628258|556610|622603|464580|464581|523952|553161|356858|622623|625911|625912|625913|625188|406365|406366|428911|436768|436769|487013|491032|491034|491035|491036|491037|491038|518364|520152|520382|548844|552794|622555|622556|622557|622558|622559|528931|558894|625072|625071|625805|625806|625807|625808|625809|625810|622560|628259|628260|622890|625073|623365|623366|412963|415752|415753|622538|998800|412962|620010|622535|622536|622539|622983|356885|356886|356887|356888|356890|439188|439227|479229|521302|356889|552534|622575|622576|622581|628290|622578|402658|410062|468203|512425|524011|545619|545620|545621|545623|545948|552587|621286|621483|621485|621486|622577|622579|622580|622588|622609|623126|623136|625657|623262|623563|479228|545947|621276|622582|622598|622585|439225|518710|518718|628362|439226|628262|625802|625803|621299|461982|486493|486494|486861|523036|451289|527414|528057|622901|622902|622922|628212|451290|524070|625084|625085|625086|625087|548738|549633|552398|625082|625083|625960|625961|625962|625963|625353|625356|622571|622572|622573|622591|622592|622593|356851|356852|404738|404739|456418|498451|515672|356850|517650|525998|622177|622277|622516|622517|622518|622520|622521|622522|622523|628222|984301|984303|622176|622276|622228|621351|621390|621792|625957|625958|622519|621793|621795|621796|622500|623250|621352|623559|621791|623658|620530|625821|628324|621268|622884|621453|622684|625122|621062|621063|625076|625077|625074|625075|622946|625102|622942|622994|622583|622584|622950|622951|621201|623513|621077|621245|621277|62707866|62707877|62707888|62707899|625180|356827|356828|356830|402673|402674|438600|486466|519498|520131|524031|548838|622148|622149|622268|356829|622300|628230|622269|625099|625953|625350|625351|625352|519961|625839|622393|940023|421317|602969|621420|621468|623111|422160|422161|621030|622886|622388|628360|622695|940012|622178|628358|622179|622394|940025|621279|622281|622316|940022|602907|622986|622989|622298|940032|621977|622325|623029|623105|622475|621244|623081|623108|622955|625811|628285|622466|628309|622383|622385|628299|62326513|625800|628242|622595|622303|622596|622305|621259|622333|940050|940051|628204|622449|623067|622450|628278|625502|625503|625135|622476|625155|622486|623026|623086|628291|628302|622397|622398|940054|623598|628205|622426|625995|628214|625529|625335|622428|623016|622134|940018|60326513|940060|622415|628329|625190|940040|622139|621269|622275|940061|621252|622146|622440|940047|622418|940002|622413|623188|628357|622321|625001|628273|622427|940070|625901|622898|628281|628282|622806|628283|622900|622391|940072|628319|622132|621340|621341|623073|622140|622141|628395|622335|623001|622165|628295|625950|623210|625359|622315|622337|622411|622448|622860|622870|623150|622866|622880|622881|620118|628279|622864|622777|621497|622888|628398|622868|622899|628255|625988|622626|625946|628200|622566|622567|622625|504923|622422|622447|940076|531659|622157|435744|435745|483536|622525|622526|998801|998802|528020|622155|622156|526855|356869|356868|625360|625361|628296|625825|625823|628210|622283|625902|621010|628351|622740|625036|621014|621028|628250|628253|628378|628385|621755|622945|628355|628339|628325|628303|628389|628380|628315|621738|621272|628331|625850|628340|628356|625201|621591|622961|622508|623660|623505|622441|623623|628377|627069|627066|627067|627068|622478|621495|940013|625101|622462|628272|622128|623035|623186|623296|622129|940038|985262|622322|62326581|622369|622412|621523|623055|621013|625889|628254|623276|622312|628381|622481|622341|940058|623115|940020|621465|621528|621258|622867|622885|900105|900205|621521|621690|622320|628375|622319|625288|625888|628298|625186|628336|625526|621024|622339|620500|622289|622389|628300|625516|628248|622648|622488|623110|622686|622288|628280|628247|625182|622895|623125|621592|628323|625121|628330|621008|621525|621287|628277|625150|628326|625225|625226|628387|621065|623017|623213|621517|628289|622302|628297|625097|628332|625183|628399|621449082|625126|628320|621056802|621056805|621056801|621056803|622995|622975682|622975681|621260119|621260103|621260121|621260123|621260105|621260117|621260113|621260107|621260108|621260109|621260111|621260112|621260115|621260106|621260110|621260116|621260122|621260120|621260002|621260102|621260001|621260118|621260136|621260125|621260132|621260127|621260130|621260135|621260133|621260128|621260131|621260129|621260126|621275341|621275171|621275181|621275291|621275281|621275111|621275191|621275121|621275321|621275221|621275201|621275251|621275161|621275131|621275241|621275271|621275231|621275141|621275261|621275101|621275151|621275361|621275351|621275301|621275371|621275211|621275311|621275331|621092007|621092003|621092002|621092001|621092008|621092006|621092004|621092005|621092011|621092012|621092010|621241001|621241003|621241002|621241004|622218|628267|621346003|62354320|621346002|621346102|621346001|62354332|62354331|621326919|621326969|621326979|621326878|621326989|621326939|621326888|621326626|621326898|621326999|621326828|621326959|621326858|621326848|621326868|621326929|621326838|621326818|621326949|621338005|621338008|621338001|621338007|621338003|621338002|621338010|621338006|621338009|621338011|621353121|621353008|621353108|621353113|621353115|621353117|621353002|621353102|621353005|621353105|621353007|621353107|621353003|621353103|621353006|621353106|621353109|621353001|621353101|621353124|621353110|621353112|621353111|621353123|621353122|621353118|621353119|621353120|621356092|621356094|621356124|621356095|621356083|621356125|621356123|621356118|621356032|621356120|621356034|621356121|621356116|621356119|621356040|621356117|621356111|621356014|621356038|621356013|621356112|621356108|621356109|621356107|621356091|621356113|621356055|621356046|621356044|621356030|621356026|621356016|621356015|621356029|621356047|621356059|621356054|621356027|621356101|621356105|621356023|621356084|621356005|621356102|621356103|621356018|621356048|621356024|621356104|621356006|621356004|621356003|621356017|621356036|621356049|621356025|621356051|621356020|621356019|621356070|621356071|621356021|621356114|621356086|621356087|621356050|621356007|621356009|621356008|621356002|621356045|621356062|621356001|621356061|621356010|621356012|621356042|621356011|621356085|621356122|621356096|621356089|621356033|621356035|621356053|621356056|621356063|621356088|621356028|621356037|621356052|621356069|621356074|621356058|621356072|621356041|621356039|621356073|621356022|621356067|621356079|621356080|621356078|621356081|621356068|621356082|621356066|621356065|621356077|621356057|621356060|621356031|621356100|621356097|621356099|621356098|621356043|621356076|621356075|621356115|621356064|621356090|621356093|621347102|621347108|621347105|621347103|621347101|621347106|621347107|621350010|623589010|623589020|621350020|621350431|623589431|623589001|623589451|621350451|621350001|623589027|621350013|623589013|623589026|623589005|621350005|623589021|621350009|623589009|621350003|623589003|621350002|623589002|621350015|621350004|623589004|623589015|621350006|623589006|621350011|623589011|621350016|623589016|621350007|623589007|621350755|623589755|623589017|621350017|623589025|623589024|621350014|623589014|623589028|621350019|623589012|621350012|621350008|623589008|621350018|623589019|623589018|621350943|623589943|623589023|623589022|621399011|621365006|621365001|621365012|621365011|621365005|621365013|621365014|621365007|621365004|621365009|621365008|621365003|621365002|621365010|621401001|621401002|623143005|623143003|623143001|623143004|623143002|621393001|62139383|621623001|621397102|621397001|621397101|621627008|621627005|621627002|621627001|621627007|621627009|621627003|621627006|621627010|621635101|621635114|621635003|621635103|621635124|621635004|621635104|621635112|621635109|621635111|621635013|621635113|621635119|621635010|621635110|621635005|621635105|621635007|621635107|621635118|621635122|621635115|621635108|621635117|621635125|621635123|621635120|621635106|621635102|621635116|621650105|621650104|621650003|621650002|621650102|621650001|621650101|621630002|621630102|621630003|621630103|621630001|621630101|62163113|62163103|62163122|62325400|62163119|62163120|62163112|62163117|62163114|62163116|62163115|62163104|62163118|62163108|62325401|62163127|62163107|62163121|62163125|62163101|62163123|62163126|62163102|62163109|62325402|62163110|62163111|621637009|621637008|621637006|621637007|621637005|621637004|621637001|621637002|621637003|621653002|621653003|621653004|621653005|621653007|621653006|621653001|621628661|621628662|621628660|621675002|621675001|621675004|621675005|621675003|621656002|621396|621656001|621659002|621659001|62165934|621659006|621659009|62165954|621659008|621659010|621659003|621398001|621398002|621676021|621676014|621676009|621676010|621676001|621676002|621676003|621676006|621676024|621676035|621676025|621676013|621676012|621676023|621676011|621676008|621676040|621676037|621676038|621676039|621676036|621676041|621676005|621676026|621676004|621676027|621676029|621676028|621676015|621676019|621676020|621676030|621676022|621676031|621676032|621676046|621676018|621676033|621676045|621676044|621676042|621676043|621676048|621676047|621676034|621676016|621676017|621678108|621678102|621678105|621678103|621678101|621678601|621678106|621678107|621678001|621678501|621678110|621678002|621678502|621678109|621678128|621678127|621678126|621678125|621678301|621678208|621678708|621678213|621678713|621678207|621678707|621678209|621678709|621678211|621678711|621678113|621678212|621678712|621678112|621678111|621678202|621678702|621678201|621678701|621678203|621678703|621678205|621678705|621678206|621678706|621678117|621678116|621678210|621678710|621678119|621678121|621678118|621678124|621678215|621678715|621678122|621678115|621678120|621678114|621678123|621679004|621679013|621679012|621679008|621679005|621679001|621679003|621679002|621679007|621679006|621679009|621679010|621679011|621681005|621681102|621681103|621681101|621682002|621682801|621682839|621682101|621682803|621682102|621682805|621682106|621682808|621682103|621682806|621682105|621682807|621682110|621682812|621682111|621682813|621682109|621682811|621682108|621682810|621682107|621682809|621682202|621682816|621682201|621682815|621682203|621682817|621682205|621682818|621682209|621682822|621682208|621682821|621682210|621682823|621682213|621682827|621682211|621682825|621682212|621682826|621682207|621682820|621682206|621682819|621682003|621682802|621682301|621682828|621682302|621682829|621682305|621682831|621682307|621682833|621682306|621682832|621682309|621682836|621682308|621682835|621682310|621682837|621682303|621682830|621682311|621682838|621685701|621685702|621687001|62169757|62169724|62169734|62169769|62169768|62169767|62169716|62311703|62311701|621380001|621381001|621382019|621382018|621382020|621382001|621382002|621382006|621382005|621382010|621382009|621382007|621382008|621382003|621382004|621382025|621382013|621382017|621382021|621382023|621382015|621382016|621382012|621382014|621382024|621382027|621382011|621382022|621382026|62319563|621383001|621383002|621265001|62127852|62127834|62127843|62127825|62127839|62127861|62127858|62127827|62127823|62127877|62127822|62127821|62127828|62127820|62127836|62127837|62127831|62127832|62127855|62127810|62127816|62127817|62127812|62127815|62127813|62127801|62127800|62127818|621384001|621368001|621386002|621386001|621386003|621386004|621699008|621699002|621699007|621699001|621699005|621699003|621699006|623601001|623604001|623608001|623608002|623609001|623609002|623609003|623609006|623609005|62361026|62361027|62361025|62361028|623512001|623045001|623607012|623607006|623607014|623607015|623607011|623607008|623607013|623607007|623607002|623607003|623607004|623607010|623607001|623607005|623607009|623522001|623504010|623504002|623504008|623504004|623504009|623504001|623504005|623517001|623504003|623504006|623504007|623525003|623525004|623525022|623525005|623525006|623525025|623525023|623525024|623525009|623525021|623525020|623525002|623525008|623525007|623525001|62352739|62352760|62352755|62352733|62352759|62352737|62352784|623532001|623145001|62314061|62314062|623538001|62355001|62355358|623558617|623558618|62355865|623558621|623558615|623558622|623558611|623558616|623558612|623558613|623558620|623558619|62358421|62359430|62368004|62368001|62368002|62368003|623580001|623579001|62358563|623587001|623587002|62359065|62359364|62359354|62359356|62359350|62359353|62359329|62359349|62359351|62144735|621658001|62165826|62361345|62361346|62361347|62314292|62361528|62361527|62361560|62361523|62361522|62361525|62361526|623626706|623626704|621382076|621382070|621382053|621382077|621382066|621382078|621382063|621382052|621382068|621382074|621382051|621382057|621382058|621382080|621382061|621382062|621382067|621382060|621382072|621382064|621382056|621382050|621382075|621382073|621382079|621382069|621382071|621382054|621382065|621382059|621382055|62363585|62363440|62363441|62363442|62361912|62361982|62317475|62354290|62354211|62354215|62354213|62165271|62365178|62354901|623567001|623567002|62363914|62363938|62363974|62363975|62363940|62363971|62367292|62367291|62364710|62314289|62314259|62364178|62364194|62354884|62354897|62354879|62369470|62707403|62707411|62707405|62707406|62707407|62707410|62707409|62707408|62707401|62707402|627063003|627063001|627063002|62367933|62367934|62367935|62367936|62360530|62149445|62316424|62316420|62316438|62316448|62316446|62316443|62316483|62316442|62704119|62704118|62707522|62707531|62707528|622372|622471|622472|622371|625091|622293|622295|622296|622297|622373|622451|622294|625940|622871|622958|622963|622957|622798|625010|622381|622382|621487|621083|622487|622490|622491|622492|621034|622386|622952|625107|622387|622423|625062|625063|622360|622361|625034|625096|625098|624326|625026|625024|622376|622378|622377|625092|622453|622456|624303|625008|625009|624337|626396|625055|625040|625042|625044|625046|625048|625053|625058|625060|625136|625172|625174|625176|624472|624483|626206|626208|626210|626212|626214|625141|625143|622750|622751|625145|625147|625196|625198|624474|624485|623040|620202|620203|622348|629225|623041|620208|620209|622351|623042|620206|620207|622355|622493|624489|620204|620205|621084|623350|624412|622948|621740|622482|622483|622484|623334|629131|629140|624468|626407|624477|624478|624481|629139|624488|629148|629238|629239|624458|622675|622676|622677|624329|629173|629174|629175|626240|629221|920232|920239|920332|920339|920432|920439|941643|941725|944022|944631|944664|945903|625842|622433|622861|622932|622862|622775|622785|624300|624302|624308|624309|622920|624407|624408|623043|623064|624371|624372|624398|622403|601100|601101|601121|601123|601124|601125|601126|601127|601128|601122|601131|601136|601137|601138|601140|601142|601143|601144|601145|601146|601147|601148|601149|601174|601178|601186|601187|601188|601189|601177|601179|625014|625016|622549|622550|623357|624341|622354|623488|621224|622954|621295|625124|625154|623457|622444|622414|626221|621049|622445|621000|620011|620027|620031|620039|620103|620106|620123|620125|620220|620278|620812|621006|621025|621027|620132|625003|625011|625012|625020|625025|625027|625031|625039|625078|625079|625120|625127|625032|625244|621484|621640|621641|625245|625246|624344|623395|624384|624345|623391|623392|624381|624382|623451|623452|623453|624448|624375|624482|629141|629149|629150|621639|623394|626415|626416|624451|624452|625006|625023|625103|625106|625111|625112|625123|625125|625131|625132|625139|625178|625243|621079|621003|621011|621012|621023|621031|621032|621039|621078|625242|626275|625241|624449|624450|624414|624347|621045|622356|621234|622145|625013|622130|621257|621055|620009|625002|625033|625035|625007|620015|620024|625004|621349|620108|621354|623326|623327|620532|624313|624333|623358|625904|624314|621645|626233|626234|626235|629176|629177|621624|623332|624338|624351|623339|623370|624435|624436|626399|626400|626409|626236|626237|626261|621642|624366|621654|625804|623374|624370|624434|626402|623489|624358|624462|620056|625814|625817|624399|624400|624401|624410|624411|626395|624413|624440|624441|624442|624443|626222|624444|623316|623317|623315|620079|620091|622164|624357|621657|623024|625840|625841|624331|624348|624332|626394|624339|624432|624479|624480|621794|625944|623347|624428|624429|626398|624306|624322|623300|623302|623303|623304|623324|623492|623398|623307|623311|623312|623313|623323|623341|624320|624321|624324|624325|624387|624388|624349|624350|624335|624359|624360|624362|624363|626344|623314|624490|623325|623375|629144|623331|623348|623336|623337|623338|624323|623360|623344|623499|623493|623359|623362|623364|624364|624352|624353|624354|623381|623402|623380|624367|623385|623383|623386|623388|624368|624376|624377|624378|623389|623417|623418|623419|623420|623421|629180|623410|623411|624392|624393|624394|624395|624396|621052|623414|624391|623448|623443|623355|626289|626293|626294|624416|624418|620120|621020|621220|623379|623393|623454|623470|624343|624346|624373|624374|624380|624404|624420|624424|624437|624446|625220|625320|626250|626251|626277|624336|624361|626426|624389|624427|624471|624423|624425|624459|623456|624455|629142|626202|629152|626219|626412|626413|629166|629167|629283|626231|629172|626297|622194|629215|629217|620129|626279|629248|625945|622346|622347|622349|622350|622352|622353|620515|620048|920000|622812|622810|622811|628310|625919|625368|625367|518905|622835|625603|625605|625206|625052|625215|400360|403391|403392|404158|404159|404171|404172|404173|404174|404157|433667|433669|514906|403393|520108|433666|558916|622680|622688|622689|628206|556617|628209|518212|628208|356390|356391|356392|622916|622918|622919|628370|628371|628372|622766|622767|622768|622678|622679|622657|622685|622659|622687|625981|625979|356839|356840|406252|406254|425862|481699|524090|543159|622161|622570|622650|622655|622658|625975|625977|628201|628202|625976|625339|622801|625978|625980|625974|622800|523959|528709|539867|539868|622637|622638|628318|528708|622636|625967|625968|625969|625971|625970|625831|622693|625833|625993|628221|625191|622265|622266|625973|622883|625972|625093|625095|522001|622163|622853|628203|622851|622852|625816|625165|628314|625169|625903|622778|628207|622282|622318|512431|520194|628379|625890|625050|625836|628367|622875|628333|625208|628349|622921|628321|625598|622286|628236|621777|623270|622813|622818|628228|625166|628359|628274|625163|628341|625216|628270|628311|622710|628294|628261|628251|622651|625828|625652|625700|625358|622613|628220|622809|628224|625119|625577|625952|628213|622533|622537|625167|628345|622416|628263|625370|622718|628305|628361|625202|628239|625195|628238|628257|628304|622817|628287|625959|625129|628391|628233|628264|628231|625157|628353|625187|625209|628327|625205|625203|628275|622565|622717|622287|628252|628306|628227|628234|628337|628237|628365|628219|625168|625369|622270|625090|628368|625588|625212|628373|628293|625192|628276|622611|628211|625500|625989|625701|622722|625838|628243|625080|628235|628322|625088|622469|628307|628229|628397|622802|622290|628232|625128|625357|622829|625819|628301|622808|628308|622815|622816|628226|625189|628223|621416|628217|628284|625820|628382|625158|622569|628369|625506|622906|628386|625519|623092|628392|625992|628244|628364|628350|625133|625152|628342|625156|628271|625886|628328|625891|628347|625200|628343|625837|628354|621293|621294|621342|621343|621364|621394|623423|629153|623485|621248|629163|621215|621249|625829|625943|621231|622790|624405|623369|621356106|621356110|624403|624406|624334)\\d{10}|(6201361|6230740|6230741|6235241|6251640|6251642|6251643|6251644|6251645|6258240|6258241|6258242|6258243|6258244|6258245|6251641|6201364|6235249|62926010|62926011|62926012|62926013|62926014|62926015|62926016|62926017|62926018|62926019|62926906|62926907|62926908|62926909|62926910|62926911|6245806|6253098|374738|374739|370246|370247|370248|370249|370267|6243190|6243191|6243192|6243193|6244220|6244221|6244222|6244223|6349102|6353591|377677|6233670|6233671|6233672|6233673|6233674|6233675|6234340|6234341|6234342|6234343|6234344|6234345|405512|601428|66405512|66601428|377152|377153|377158|377155|690755|370285|370286|370287|370289|6223091100|6223092900|6223093310|6223093320|6223093330|6223093370|6223093380|6223096510|6223097910|62326576|6229756114|6229756115|621326763|621392887|621681001|621681002|621681003|621687913|621697813|621697793|621697873|621689007|621689001|621689002|621689004|621689005|621689006|621689003|621387973|621381002|621381003|621385663|621278193|621278293|621278503|621278333|623678353|623502001|623519533|623530963|623530953|623194773|621652853|6258433|6258434|6011290|6011291|6011292|6011293|6011295|6011297|6011294|6011296|6011300|6011390|6011392|6011393|6011391|6011399|6234500|6234501|6264030|6264031|6264032|6244950|6244951|6244952|6244953|6244954|6233710|6233712|6233720|6233722|6233723|6233730|6233732|6233760|6233762|6243650|6243652|6243651|6233711|6233721|6233731|6233761|6234280|6234290|6250386|6201086|6201088|6216846|6216848|6250388|6234610|6292740|6244760|6233451|6233452|6233453|6233454|6233455|6214455|6214458|6234240|6234241|6234242|6244570|6233493|6233494|6243051|6243052|6262740|6243550|6243551|6243560|6243561|6262440|6262450|6262451|6233603|6233604|6233605|6233461|6233462|6233463|6221441|6243420|6243421|6243422|6243423|6243424|6243425|6233681|6221740|6233840|6233841|6233820|6233821|6233822|6233823|6233824|6233960|6233961|6234460|6234461|6234462|6234470|6234211|6291802|6234090|6243900|6243901|6243902|6233990|6233991|6234150|6234151|6234152|6234154|6234250|6234251|6234252|6234253|6234220|6234270|6234320|6234321|6234322|6234323|6234330|6234350|6234351|6234352|6234420|6234421|6234422|6234450|6234451|6234452|6234453|6244160|6234440|6234441|6292710|6292711|6234670|6263740|6234671|6263741|6292720|6292790|6292791|6234750|6234620|6234621|6234622|6234623|6244650|6244651|6244652|6244653|6262580|6262581|6244700|6244701|6244702|6264080|6264081|6264082|62349600|62349100|62349101|6262300|6262180|6262181|6262182|6262183|6262184|6262185|6262490|6262480|6262550|6262530|6262560|6262570|6262730|6262720|6292360|6262820|6262830|6262910|6262920|376968|376969|376966|377187|6227890|6227891|6227892|6227893|6227894|6227895|6227896|6227897|6227899|6227898)\\d{9}|(62636209|62636210|62636211|62636212|62451804|62451810|62451811|62458071|360883|360884|62844801|62137310|62137320|62592310|62592320|62592340|62013101|62013102|62176410|62176420|62592110|62592120|62592140|62594250|62594260|62594270|62629621|62431940|62442240|62844803|62844802|62589700|62560602|62844800|62928600|62928601|62152400|62519326|62599400|62565801|62326510|62844811|62519315|62599506|60326500|62326522|62560600|62565800|62228306|62228308|62844805|62364302|62519311|62519317|62519327|62844706|62844810|62326611|62231902|90010502|90020502|62519313|62364324|62519325|62844705|62105913|62105903|62105916|62105906|62105915|62105905|62105901|62105911|62105900|62105902|62519306|62515901|62355701|62355702|62355703|62312405|62312401|62312406|62312402|62312403|62911050|62431001|62626000|62629502|62629500|62628601|62925100|62925101|62629632|62628000|62628001|62629600|62629633|60112010|60112011|60112012|60112089|60112013|60112980|60112981|60112986|60112987|60112988|60112989|60112990|60112991|60112992|60112993|60112996|60112997|60113080|60113081|60113089|60112995|60113940|60113941|60113943|60113944|60113945|60113946|60113984|60113985|60113986|60113988|60112994|60113989|62629602|62345800|62927700|62345801|62345802|62345803|62927701|62445400|62922400|62349550|62235600|62915500|62915501|62915502|62915503|62925600|62915504|62629800|62629801|62913200|62446600|62624100|62624101|62910100|62910101|62910102|62910103|62910104|62910120|62910121|62445300|62924200|62621701|62641002|62641001|62443100|62443101|62911028|62927300|62921600|62334910|62334911|62334912|62334921|62334923|62334913|62334950|62334951|62916501|62916500|62641000|62621700|62335201|62335202|62335203|62911071|62911505|62335101|62335102|62335103|62335104|62335105|62335106|62335107|62335108|62441900|62441901|62441902|62629608|62629609|62911014|62348700|62928400|62340500|62622700|62622701|62622702|62916100|62916101|62622800|62929505|62341403|62341407|62341408|62341409|62341401|62341402|62344901|62441701|62347800|62927800|62344902|62927801|62915700|62438500|62343800|62344000|62344001|62441500|62441501|62344100|62345500|62346000|62346001|62340410|62340420|62348100|62348101|62346400|62442600|62442601|62346600|62443000|62443001|62443002|62446300|62640400|62443800|62924400|62629607|62924401|62924402|62347600|62444500|62444501|62444502|62444503|62913000|62913002|62913003|62622300|62913004|62348000|62348001|62629000|62340610|62340620|62340630|62929512|62446700|62446720|62446710|62348400|62347900|62914700|62928100|62446900|62921400|62913800|62913300|62622000|62620401|62620402|62915800|62913500|62624301|62921200|62915100|62917800|62915101|62915400|62915401|62915402|62915403|62449600|62449601|62449700|62449701|62641100|62621600|62621601|62912901|62623900|62912800|62912900|62620500|62916201|62916200|62438600|62438601|62916400|62916401|62916402|62917100|62622500|62622600|62224100|62916800|62629604|62629605|62642500|62911008|62929500|62916900|62340700|62340701|62340705|62340706|62622900|62623200|62641400|62623201|62623202|62641401|62911025|62911026|62911027|62623800|62624200|62624201|62921100|62917900|62629610|62629611|62629612|62629613|62624700|62624701|62624702|62641800|62641801|62641802|62641803|62641804|62348300|62348301|62929509|62625900|62625901|62625400|62922000|62922200|62922201|62922001|62922700|62629615|62629603|62922300|62925400|62925500|62925401|62922800|62922801|62923000|62923001|62928900|62928901|62924900|62627600|62642300|62922600|62928700|62629645|62629646|62629647|62911041|62911042|62911043|62911044|62911045|62911046|62629623|62911056|62911057|62911058|62923300|62929000|62924000|62924100|62923700|62929100|62627800|62627801|62627802|62627803|62924700|62629668|62629669|62629650|62911000|62911001|62911003|62628700|62628701|62628800|62628801|62642400|62642504|62642505|62629110|62629111|62642516|62642517|62642511|62642512|62629601|62340702|62910000|62911100|62911101|62348200|62348201|62348202|62629606|62911009|62911010|62911011|62911006|62911007|62629652|62629630|62629631|62629616|62629617|62911037|62911040|62911021|62911020|62629622|62629628|62629629|62642503|62909501|62911030|62911200|62911038|62629639|62929508|62629644|62642506|62642507|62642508|62911039|62929506|62929507|62911035|62911036|62629648|62642509|62642510|62629651|62911047|62911048|62911064|62911065|62293400|62293401|62629658|62911066|62911067|62911061|62911062|62629653|62629654|62642513|62642514|62911068|62911074|62911075|62911090|62911091|62911092|62911076|62911077|62911093|62911094|62911095|62911078|62911079|62911096|62911097|62911098|62911072|62911503|62911504|62824501|62844806|62519320|62519321|62844702|62844813|62519318|62560601|62599402|62519323|62519301|62521800|62521802|62844700|62536601|62519310|62519308|62519316|62519305|62519309|62516808|62516809|62536602|62521201|62521202|62844807|62824500|62519303|62844812|62844703|62629673|62629655|62629657|62629663|62911600|62929513)\\d{8}|(628375202|628375602|623503001|621250004|621250006|621250003|621250011|621250001|621250012|621250008|621250010|621250005|621250002|621250009|621250007|621347002|621347008|621347005|621347003|621347001|621347006|621347007|621399017|621399008|621399001|621399012|621399016|621399015|621399004|621399025|621399026|621399023|621399024|621399028|621399002|621399018|621399014|621399010|621399009|621399011|621399013|621399003|621399007|621399005|621399006|621399021|621399019|621399027|621399029|621399020|621399022|621316001|621355052|621355002|621355051|621355001|621656003|621680002|621680102|621680007|621680107|621680009|621680109|621680112|621680010|621680110|621680005|621680105|621680003|621680103|621680113|621680004|621680104|621680006|621680106|621680008|621680108|621680011|621680111|623535002|623535005|623535006|623535008|623535003|623535001|623535004|623535007)\\d{7})$/';

    // 系统配置key正则
    public const CONFIG_KEY = '/^[a-zA-Z0-9_]{3,}$/';

    // 系统路径正则
    public const PATH_URL = '/^\/+[a-z]/';

    // api路径验证规则
    public const API_URL = '/^[a-z]+\//';

    // 身份证
    public const CARD_ID = '/^[1-9]\d{5}(18|19|([23]\d))\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{3}[0-9Xx]$/';

    // 手机号码
    public const PHONE_NUMBER = '/^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\d{8}$/';

    // 时间验证
    public const TIME_RULE = '/^[0-9]{1,2}-[0-9]{1,2}\s{1}[0-9]{2}:[0-9]{2}:[0-9]{2}/';

    // 小时验证
    public const HOUR_TIME_RULE = '/^[0-9]{2}:[0-9]{2}:[0-9]{2}/';

    public const DAT_TIME_RULE = '/^[0-9]{1,2}\s[0-9]{2}:[0-9]{2}:[0-9]{2}/';

    // 月份验证
    public const MONTH_TIME_RULE = '/^[0-9]{4}-[0-9]{1,2}/';

    // 年月日验证
    public const YEAR_MONTH_DAY_RULE = '/^[0-9]{4}-[0-9]{2}-[0-9]{2}]/';

    // 中文或字母数字
    public const CHINESE_OR_ALPHABET = '/^[\x{4e00}-\x{9fa5}A-Za-z0-9_]+$/u';

    // 中文或字母数字或特殊字符
    public const CHINESE_OR_ALPHABET_OR_CHARACTER = '/^[\x{4e00}-\x{9fa5}A-Za-z0-9_()（）_\-\/*]+$/u';

    /**
     * 获取登录密码验证规则.
     * @return string
     */
    public static function loginRegex(array $type = [])
    {
        $type   = $type ?: sys_config('login_password_type');
        $type   = is_array($type) ? $type : [0, 2];
        $length = (int) sys_config('login_password_length', 5);
        // 纯数字
        $regex['0'] = '/^\d{' . $length . ',}$/';
        // 数字+大写字母
        $regex['01'] = '/^(?=.*[A-Z])(?=.*\d)[A-Z\d]{' . $length . ',}$/';
        // 数字+小写字母
        $regex['02'] = '/^(?=.*[a-z])(?=.*\d)[a-z\d]{' . $length . ',}$/';
        // 数字+特殊字符
        $regex['03'] = '/^(?=.*[$@$!%*.?&<>\(\)\[\]\/|,\{\}^#])(?=.*\d)[\d$@$!%*.?&<>\(\)\[\]\/|,\{\}^#]{' . $length . ',}$/';
        // 大写字母+小写字母
        $regex['12'] = '/^(?=.*[a-z])(?=.*[A-Z])[a-zA-Z]{' . $length . ',}$/';
        // 大写字母+特殊字符
        $regex['13'] = '/^(?=.*[A-Z])?=.*[$@$!%*.?&<>\(\)\[\]\/|,\{\}^#])[A-Z$@$!%*.?&<>\(\)\[\]\/|,\{\}^#]{' . $length . ',}$/';
        // 小写字母+特殊字符
        $regex['23'] = '/^(?=.*[a-z])?=.*[$@$!%*.?&<>\(\)\[\]\/|,\{\}^#])[a-z$@$!%*.?&<>\(\)\[\]\/|,\{\}^#]{' . $length . ',}$/';
        // 数字加小写字母加大写字母
        $regex['012'] = '/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)[a-zA-Z\d]{' . $length . ',}$/';
        // 数字+小写字母+大写字母+特殊字符
        $regex['0123'] = '/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[$@$!%*.?&<>\(\)\[\]\/|,\{\}^#])[A-Za-z\d$@$!%*.?&<>\(\)\[\]\/|,\{\}^#]{' . $length . ',}/';
        // 数字+大写字母+特殊字符
        $regex['013'] = '/^(?=.*[A-Z])(?=.*\d)(?=.*[$@$!%*.?&<>\(\)\[\]\/|,\{\}^#])[A-Z\d$@$!%*.?&<>\(\)\[\]\/|,\{\}^#]{' . $length . ',}$/';
        // 数字+小写字母+特殊字符
        $regex['023'] = '/^(?=.*[a-z])(?=.*\d)(?=.*[$@$!%*.?&<>\(\)\[\]\/|,\{\}^#])[a-z\d$@$!%*.?&<>\(\)\[\]\/|,\{\}^#]{' . $length . ',}$/';
        // 小写字母+大写字母+特殊字符
        $regex['123'] = '/^(?=.*[a-z])(?=.*[A-Z])(?=.*[$@$!%*.?&<>\(\)\[\]\/|,\{\}^#])[A-Za-z$@$!%*.?&<>\(\)\[\]\/|,\{\}^#]{' . $length . ',}/';
        sort($type);
        $typeStr = implode('', $type);
        return $regex[$typeStr];
    }
}
