<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace crmeb\traits\model;

use App\Http\Model\BaseModel;
use Illuminate\Support\Facades\Schema;

/**
 * 关联查询
 * Trait RelationTrait.
 *
 * @mixin  BaseModel
 */
trait RelationTrait
{
    protected mixed $entId = null;

    public function setEntId($entId)
    {
        $this->entId = $entId;
        return $this;
    }

    public function hasOne($related, $foreignKey = null, $localKey = null)
    {
        $instance = $this->newRelatedInstance($related);

        $foreignKey = $foreignKey ?: $this->getForeignKey();

        $localKey = $localKey ?: $this->getKeyName();

        $hasOne = $this->newHasOne($instance->newQuery(), $this, $instance->getTable() . '.' . $foreignKey, $localKey);
        if ($this->entId) {
            if (Schema::hasColumn($instance->getTable(), 'entid')) {
                $hasOne = $hasOne->where($instance->getTable() . 'entid', $this->entId);
            }
        }
        return $hasOne;
    }

    /**
     * Define a one-to-many relationship.
     *
     * @param string $related
     * @param string|null $foreignKey
     * @param string|null $localKey
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function hasMany($related, $foreignKey = null, $localKey = null)
    {
        $instance = $this->newRelatedInstance($related);

        $foreignKey = $foreignKey ?: $this->getForeignKey();

        $localKey = $localKey ?: $this->getKeyName();

        $hasMany = $this->newHasMany(
            $instance->newQuery(), $this, $instance->getTable() . '.' . $foreignKey, $localKey
        );
        if ($this->entId) {
            if (Schema::hasColumn($instance->getTable(), 'entid')) {
                $hasMany = $hasMany->where($instance->getTable() . '.entid', $this->entId);
            }
        }
        return $hasMany;
    }

    /**
     * Define a has-one-through relationship.
     *
     * @param string $related
     * @param string $through
     * @param string|null $firstKey
     * @param string|null $secondKey
     * @param string|null $localKey
     * @param string|null $secondLocalKey
     * @return \Illuminate\Database\Eloquent\Relations\HasOneThrough
     */
    public function hasOneThrough($related, $through, $firstKey = null, $secondKey = null, $localKey = null, $secondLocalKey = null)
    {
        $through = $this->newRelatedThroughInstance($through);

        $firstKey = $firstKey ?: $this->getForeignKey();

        $secondKey = $secondKey ?: $through->getForeignKey();

        $hasOne = $this->newHasOneThrough(
            $this->newRelatedInstance($related)->newQuery(), $this, $through,
            $firstKey, $secondKey, $localKey ?: $this->getKeyName(),
            $secondLocalKey ?: $through->getKeyName()
        );
        if ($this->entId) {
            $relatedTable = $this->newRelatedInstance($related)->getTable();
            if (Schema::hasColumn($relatedTable, 'entid')) {
                $hasOne = $hasOne->where($relatedTable . '.entid', $this->entId);
            }
            if (Schema::hasColumn($through->getTable(), 'entid')) {
                $hasOne = $hasOne->where($through->getTable() . '.entid', $this->entId);
            }
        }
        return $hasOne;
    }

    /**
     * Define a has-many-through relationship.
     *
     * @param string $related
     * @param string $through
     * @param string|null $firstKey
     * @param string|null $secondKey
     * @param string|null $localKey
     * @param string|null $secondLocalKey
     * @return \Illuminate\Database\Eloquent\Relations\HasManyThrough
     */
    public function hasManyThrough($related, $through, $firstKey = null, $secondKey = null, $localKey = null, $secondLocalKey = null)
    {
        $through = $this->newRelatedThroughInstance($through);

        $firstKey = $firstKey ?: $this->getForeignKey();

        $secondKey = $secondKey ?: $through->getForeignKey();

        $hasMany = $this->newHasManyThrough(
            $this->newRelatedInstance($related)->newQuery(),
            $this,
            $through,
            $firstKey,
            $secondKey,
            $localKey ?: $this->getKeyName(),
            $secondLocalKey ?: $through->getKeyName()
        );
        if ($this->entId) {
            $relatedTable = $this->newRelatedInstance($related)->getTable();
            if (Schema::hasColumn($relatedTable, 'entid')) {
                $hasMany = $hasMany->where($relatedTable . '.entid', $this->entId);
            }
            if (Schema::hasColumn($through->getTable(), 'entid')) {
                $hasMany = $hasMany->where($through->getTable() . '.entid', $this->entId);
            }
        }
        return $hasMany;
    }
}
