package com.bcxin.identity.domains.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import lombok.Getter;

@Getter
public class IdentityUser_WechatBindEvent extends DomainEventAbstract<String> {
    private final String tenantUserId;
    private final String openId;
    private final String nicky;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param data
     * @param openId
     */
    public IdentityUser_WechatBindEvent(String data, String openId, String nicky) {
        super(data);
        this.tenantUserId = data;
        this.openId = openId;
        this.nicky = nicky;
    }


    public static IdentityUser_WechatBindEvent create(String data, String openId, String nicky) {
        return new IdentityUser_WechatBindEvent(data, openId, nicky);
    }
}
