package com.bcxin.backend.domain.repositories;

import com.bcxin.backend.domain.models.MessageDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface MessageDtoRepository extends JpaRepository<MessageDto,String> {
    @Query("select d from MessageDto d where d.status <> com.bcxin.saas.core.enums.ProcessesStatus.Done order by d.lastProcessedTime")
    public Page<MessageDto> getPendings(Pageable pageable);
}
