package com.bcxin.backend.tasks.signatures;

import com.bcxin.backend.domain.models.SignatureCheckDocument;
import com.bcxin.backend.domain.repositories.SignatureCheckDocumentRepository;
import com.bcxin.backend.domain.signature.common.QzConstant;
import com.bcxin.backend.domain.signature.service.BeiJingInDocumentSignature;
import com.bcxin.backend.tasks.TaskAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class SignatureDocumentCheckTask extends TaskAbstract {
    private static final Logger logger = LoggerFactory.getLogger(SignatureDocumentCheckTask.class);

    @Value("${myapps.signature.serverKey}")
    String serverKey;

    @Value("${myapps.storage.root}")
    String rootPath;
    private final BeiJingInDocumentSignature beiJingInDocumentSignature;
    private final SignatureCheckDocumentRepository checkDocumentRepository;

    public SignatureDocumentCheckTask(BeiJingInDocumentSignature beiJingInDocumentSignature,
                                      SignatureCheckDocumentRepository checkDocumentRepository) {
        this.beiJingInDocumentSignature = beiJingInDocumentSignature;
        this.checkDocumentRepository = checkDocumentRepository;
    }

    @Override
    protected void runCore() throws Exception {
        if(QzConstant.QZ_SIGNATURE_SERVER_KEY_BEIJINGIN.equals(serverKey)) {
            List<SignatureCheckDocument> documents =
                    this.checkDocumentRepository.pageQueues(0, PageRequest.of(0, 200)).getContent();
            logger.error("前缀状态自动检测：{}", documents.size());
            for (SignatureCheckDocument document : documents) {
                try {
                    boolean hasRedSeal = this.beiJingInDocumentSignature.checkPdfForRedSeal(document.getFile_url());
                    logger.error("SignatureDocumentCheckTask-前缀状态=({}): 检测(id={}); url={}", hasRedSeal ? "有签章" : "无签章", document.getId(), document.getFile_url());
                    if (!hasRedSeal) {
                        this.checkDocumentRepository.updateStatus(2, "检测失败", document.getId());
                    } else {
                        this.checkDocumentRepository.updateStatus(1, "检测成功", document.getId());
                    }
                } catch (Exception ex) {
                    logger.error("状态检测异常:id={}", document.getId(), ex);
                }
            }
        }
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.document.check";
    }
}
