package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategyFactory;
import com.bcxin.backend.domain.signature.service.SignatureToPDFService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * 将temp目录下文件剪切到in目录并触发签章接口，检索完成签章文件上传ftp并清空in、out目录下文件
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class SignatureJobMoveTask extends TaskAbstract{

    @Value("${myapps.signature.serverKey}")
    String serverKey;
//    private final SignatureToPDFService signatureToPDFService;

//    public SignatureJobMoveTask(SignatureToPDFService signatureToPDFService) {
//        this.signatureToPDFService = signatureToPDFService;
//    }


    @Override
    protected void runCore() {
        logger.error("====> 电子签章（签章PDF生成）定时任务开始：3分钟一次................");
        QzSignatureStrategy qzSignatureStrategy = QzSignatureStrategyFactory.getBYServerKey(serverKey);
        qzSignatureStrategy.scan();
//        signatureToPDFService.scan();
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.job.move";
    }

}
