package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.common.QzConstant;
import com.bcxin.backend.domain.signature.service.BeiJingInDocumentSignature;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * 检索所有遗漏的文书记录重新补录到文书签章表，每小时检索一次
 */
@Component
public class SignatureDocumentComparisonTask extends TaskAbstract{

    @Value("${myapps.signature.serverKey}")
    String serverKey;
    private final BeiJingInDocumentSignature beiJingInDocumentSignature;

    public SignatureDocumentComparisonTask(BeiJingInDocumentSignature beiJingInDocumentSignature) {
        this.beiJingInDocumentSignature = beiJingInDocumentSignature;
    }


    @Override
    protected void runCore() {
        if(QzConstant.QZ_SIGNATURE_SERVER_KEY_BEIJINGIN.equals(serverKey)){
            //北京内网文书签章初始化数据
            beiJingInDocumentSignature.comparisonDocumentSignature();
        }
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.document.comparison";
    }

}
