/**
 * 云会议列表
 */
import React, { Component } from "react";
import { connect } from "dva";
import PTable from "../../../components/Pro/PTable";
import {
  recycleFromMember,
  assignToMember,
  getHuaweiAccesstoken
} from "../../../services/api";
import SelectPersonnelPop from "../../../components/SelectPersonnelPop";
import $perModal from '../../../utils/modal/perModal';
import {
  Form,
  Input,
  Button,
  message,
  Tabs,
  Modal,
  Popconfirm,
  Select
} from "antd";
import Modify from "./Modify";
const { TabPane } = Tabs;
const { Option } = Select;
const { confirm } = Modal;
const statusList = [
  {
    value: null,
    label: "所有"
  },
  {
    value: 0,
    label: "正常"
  },
  {
    value: 1,
    label: "停用"
  },
  {
    value: 2,
    label: "未分配"
  }
];
import "../meeting.less";
@connect(state => ({
  meetingAcount: state.client.meetingAcount
}))
@Form.create()
export default class CloudConference extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: {
        keyWord: "",
        status: null,
        pageSize: 10,
        pageNumber: 1
      },
      keyWord: "",
      status: null,
      modifyStatus: false, //修改的状态
      distributionItemValue: null //当前分配选中的列表
    };
  }
  componentDidMount() {
    this._getMeetingToken();
  }
  //获取华为云会议的token
  _getMeetingToken() {
    const _this = this;
    getHuaweiAccesstoken({})
      .then(res => {
        if (res.retType === "0") {
          _this.props.dispatch({
            type: `client/setMeetingToken`,
            payload: {
              meetingAcc: res.data
            }
          });
        }
      })
      .catch(err => {
        if (err.retType !== "0") {
          const value = {
            accessToken: null,
            huaweiUserName: null,
            huaweiPassWord: null,
            huaweiSipName: null
          };
          _this.props.dispatch({
            type: `client/setMeetingToken`,
            payload: {
              meetingAcc: value
            }
          });
        }
      });
  }
  //回收
  _recover(value) {
    return (
      <Popconfirm
        overlayClassName="change-clock-pop "
        // title="回收后原会议将会失效,确定回收？"
        title={
          <div>
            <div>回收后原会议将会失效,</div>
            <div>确定回收?</div>
          </div>
        }
        onConfirm={() => {
          const param = {
            account: value.member.id,
            vmrIdList: JSON.stringify([value.id])
          };
          const _this = this;
          recycleFromMember(param).then(res => {
            if (res.retType === "0") {
              _this.setState(
                {
                  forceUpdate: true
                },
                () => {
                  _this.setState({
                    forceUpdate: false
                  });
                }
              );
            }
          });
        }}
        okText="确定"
        cancelText="取消"
      >
        <span className="action-span">回收</span>
      </Popconfirm>
    );
  }
  //分配
  _distribution(value) {
    return (
      <span
        className="action-span"
        onClick={() => {
          this.setState({
            distributionItemValue: value
          },() => {
            const { distributionItemValue } = this.state;
            $perModal({
              fetchType: 'huawei',
              type: 'radio',
              onOk: (values, close) => {
                confirm({
                  title:
                    "确定将“" +
                    distributionItemValue.vmrName +
                    "”分配给" +
                    values[0].name +
                    "?",
                  okText: "确定",
                  cancelText: "取消",
                  onOk: () => {
                    close();
                    const value = {
                      account: values[0].huaweiUserName,
                      vmrIdList: JSON.stringify([distributionItemValue.id])
                    };
                    assignToMember(value).then(res => {
                      if (res.retType === "0") {
                        this.setState(
                          {
                            forceUpdate: true
                          },
                          () => {
                            this.setState({
                              forceUpdate: false
                            });
                          }
                        );
                      }
                    });
                  }
                });
              }
            });
          });
        }}
      >
        分配
      </span>
    );
  }
  //修改
  _modify(value) {
    return (
      <span
        className="action-span"
        onClick={() => {
          this.setState({
            distributionItemValue: value,
            modifyStatus: !this.state.modifyStatus
          });
        }}
      >
        修改
      </span>
    );
  }
  render() {
    const columns = [
      {
        title: "会议ID",
        dataIndex: "vmrId",
        key: "vmrId"
      },
      {
        title: "状态",
        dataIndex: "status",
        key: "status",
        render: (text, record) => {
          return (
            <span>
              {statusList.map(item => {
                if (item.value === text) {
                  return item.label;
                }
              })}
            </span>
          );
        }
      },
      // {
      //   title: "类型",
      //   dataIndex: "startTime",
      //   key: "startTime",
      //   render: (text, record) => {
      //     // return <span>{this.addUTC(text)}</span>;
      //   }
      // },
      // {
      //   title: "所有者",
      //   dataIndex: "scheduserName",
      //   key: "scheduserName"
      // },
      {
        title: "云会议室名称",
        dataIndex: "vmrName",
        key: "vmrName"
      },
      {
        title: "套餐名称",
        dataIndex: "vmrPkgName",
        key: "vmrPkgName"
      },
      {
        title: "并发数",
        dataIndex: "vmrPkgParties",
        key: "vmrPkgParties"
      },
      {
        title: "绑定的用户",
        dataIndex: "member",
        key: "member",
        render: (text, record) => {
          return (
            <span>
              {text.mark && text.mark.indexOf("(") > -1
                ? text.mark.match(/(\S*)\(/)[1]
                : record.status === 2
                ? "未绑定"
                : text.mark}
              {/* {text.mark} */}
            </span>
          );
        }
      },
      {
        title: "绑定的硬终端",
        dataIndex: "device",
        key: "device",
        render: (text, record) => {
          return <span>{text ? text : "---"}</span>;
        }
      },
      {
        title: "操作",
        dataIndex: "action",
        key: "action",
        render: (text, record) => (
          <span>
            {record.status === 0 ? (
              <span>
                {/* 回收 */}
                {this._recover(record)}
                {/* 分配 */}
                {this._distribution(record)}
              </span>
            ) : record.status === 1 ? (
              ""
            ) : record.status === 2 ? (
              <span>
                {/* 分配 */}
                {this._distribution(record)}
              </span>
            ) : (
              ""
            )}
            {/* 修改 */}
            {record.member.id === this.props.meetingAcount &&
              this._modify(record)}
          </span>
        )
      }
    ];
    const {
      forceUpdate,
      keyWord,
      status,
      modifyStatus,
      distributionItemValue
    } = this.state;
    return (
      <div className="meeting">
        <Tabs defaultActiveKey="1" className="3">
          <TabPane tab="云会议管理" key="1">
            <div className="form">
              <label style={{ marginRight: 16 }}>
                关键字：
                <Input
                  style={{ width: "214px", marginBottom: "10px" }}
                  placeholder="请输入云会议室名称、ID及分配的用户、硬终端名称"
                  value={keyWord}
                  onChange={e => {
                    this.setState({
                      keyWord: e.target.value
                    });
                  }}
                />
              </label>
              <label style={{ marginRight: 16 }}>
                云会议室状态：
                <Select
                  value={status}
                  style={{ width: 120 }}
                  onChange={value => {
                    this.setState({
                      status: value
                    });
                  }}
                >
                  {statusList.map((item, index) => {
                    return (
                      <Option value={item.value} key={index}>
                        {item.label}
                      </Option>
                    );
                  })}
                </Select>
              </label>
              <Button
                style={{
                  marginRight: "16px",
                  marginBottom: "16px"
                }}
                type="primary"
                onClick={() => {
                  const pageParm = { ...this.state.pageParm };
                  pageParm.keyWord = keyWord;
                  pageParm.status = status;
                  this.setState(
                    {
                      pageParm
                    },
                    () => {
                      this.setState({
                        forceUpdate: false
                      });
                    }
                  );
                }}
              >
                搜索
              </Button>
              <Button
                onClick={() => {
                  const pageParm = {
                    ...this.state.pageParm,
                    keyWord: "",
                    status: null
                  };
                  this.setState(
                    {
                      pageParm,
                      keyWord: "",
                      status: null,
                      forceUpdate: true
                    },
                    () => {
                      this.setState({
                        forceUpdate: false
                      });
                    }
                  );
                }}
              >
                重置
              </Button>
            </div>
            <PTable
              style={{ marginTop: 20 }}
              columns={columns}
              url="getHuaweiCloudMeetRoomList"
              pageParm={this.state.pageParm}
              forceUpdate={forceUpdate}
            />
          </TabPane>
        </Tabs>
        {modifyStatus && (
          <Modify
            modifyStatus={modifyStatus}
            value={distributionItemValue}
            modifyOK={() => {
              this.setState(
                {
                  forceUpdate: true,
                  modifyStatus: !this.state.modifyStatus
                },
                () => {
                  this.setState({
                    forceUpdate: false
                  });
                }
              );
            }}
            modifyCancel={() => {
              this.setState({
                modifyStatus: !this.state.modifyStatus
              });
            }}
          />
        )}
      </div>
    );
  }
}
