/**
 * 选择硬件设备
 */
import React, { Component } from "react";
import { Form } from "antd";
import "../../meeting.less";
import { getProductList } from "../../../../services/api";
import StandardComponent from "./StandardComponent";

@Form.create()
export default class SelectHardEquipment extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      hardEquipmentList: [], //请求后台返回的资源列表
      buyHardEquipment: [] //用户选择的资源
    };
  }
  componentDidMount() {
    this._getProductList();
  }
  //获取资源列表
  _getProductList() {
    getProductList({
      productCategoryType: 11,
      productServiceType: 2
    }).then(res => {
      if (res.retType === "0") {
        this.setState({
          hardEquipmentList: res.data
        });
        let buyHardEquipment = [];
        res.data.length > 0 &&
          res.data.map((item, index) => {
            buyHardEquipment.push({
              name: item.name,
              productServiceType:item.productServiceType,
              productInfoList: []
            });
            item.productInfoList.length > 0 &&
              item.productInfoList.map(infoList => {
                buyHardEquipment[index].productInfoList.push({
                  productName: infoList.name,
                  // productStatus: infoList.productStatus,
                  // productTypeUrl: infoList.productTypeUrl,
                  productBuyModeId:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].productBuyModeId, //产品购买方式id
                  productBuyMode:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].productBuyMode, //购买方式
                  eachAmount:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].amount, //单价
                  unit:
                    infoList.productBuyModeList.length > 0 &&
                    infoList.productBuyModeList[0].unit, //单位
                  duration: 1, //时长
                  num: 0, //数量
                  amount: 0 //总价
                });
              });
          });
        this.setState({ buyHardEquipment });
      }
    });
  }
  render() {
    const { hardEquipmentList, buyHardEquipment } = this.state;
    return (
      <div className="resource-list">
        <div className="label">华为出品，专为云会议设计，符合会议场景，提高会议体验。</div>
        {hardEquipmentList.length > 0 &&
          hardEquipmentList.map((item, index) => {
            return (
              <StandardComponent
                itemData={item}
                buyList={buyHardEquipment[index]}
                changeBuyList={data => {
                  const buyList = JSON.parse(JSON.stringify(buyHardEquipment));
                  buyList[index] = data;
                  this.setState(
                    {
                      buyHardEquipment: buyList
                    },
                    () => {
                      this.props.changeTotal(this.state.buyHardEquipment);
                    }
                  );
                }}
                key={index}
              />
            );
          })}
      </div>
    );
  }
}
