import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
} from "antd";
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      cascaderOptions: [], //驻勤级联数据
    };
  }
  componentDidMount() {
    this.props.onSearch(this.props.form.getFieldsValue());
  }
  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      // 搜索的时候重置为第一页
      values.pageNumber = 1;
      this.props.onSearch(values);
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    const data = this.props.form.getFieldsValue();
    this.props.onSearch(data);
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="关键词">
          {getFieldDecorator('keyWord', {
            initialValue: ''
          })(
            <Input placeholder="姓名/身份证/手机号" />
          )}
        </Form.Item>
        
        <Form.Item label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>

      </Form>
    );
  }
}
