/**
 * 会议资源管理
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Alert, Row, Col, Tabs, Button } from "antd";
import { getHuaweiManageResource } from "../../../services/api";
import { withRouter } from "dva/router";
const { TabPane } = Tabs;
import "../meeting.less";
@connect(state => ({
  client: state.client.client
}))
@Form.create()
@withRouter
export default class ResourceManage extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      resourceList: [
        {
          title: "会议并发方数",
          usedCount: "0",
          sumCount: "0",
          unit: "方",
          key: "0"
        },
        {
          // title: "云会议室（运营VMR专用_25）",
          // usedCount: "0",
          // sumCount: "0",
          // unit: "个",
          // key: "1"
          vmr: []
        },
        {
          title: "用户账号数",
          usedCount: "0",
          sumCount: "0",
          unit: "个",
          key: "2"
        },
        {
          title: "1080P硬件终端接入数",
          usedCount: "0",
          sumCount: "0",
          unit: "个",
          key: "3"
        },
        {
          title: "720P硬件终端接入数",
          usedCount: "0",
          sumCount: "0",
          unit: "个",
          key: "4"
        },
        {
          title: "第三方硬件终端数",
          usedCount: "0",
          sumCount: "0",
          unit: "个",
          key: "5"
        }
        // {
        //   title: "第三方电子白板接入账号数",
        //   usedCount: "",
        //   sumCount: "",
        //   unit: "个",
        //   key: "6"
        // },
        // {
        //   title: "直播端口数",
        //   usedCount: "",
        //   sumCount: "",
        //   unit: "个",
        //   key: "7"
        // },
        // {
        //   title: "录播空间",
        //   usedCount: "0",
        //   sumCount: "0",
        //   unit: "G",
        //   key: "6"
        // }
      ]
    };
  }
  componentDidMount() {
    this._getHuaweiManageResource();
  }

  _getHuaweiManageResource() {
    getHuaweiManageResource({}).then(res => {
      if (res.retType === "0" && !!res.data) {
        const resourceList = this.state.resourceList;
        resourceList[0].usedCount = res.data.confCallCount.usedCount;
        resourceList[0].sumCount = res.data.confCallCount.sumCount;
        resourceList[1] = res.data.vmr;
        // resourceList[1].usedCount =
        //   res.data.vmr.length > 0 ? res.data.vmr[0].vmrPkgCount : "0";
        // resourceList[1].sumCount =
        //   res.data.vmr.length > 0 ? res.data.vmr[0].vmrPkgParties : "0";
        resourceList[2].usedCount = res.data.teSoftCount.usedCount;
        resourceList[2].sumCount = res.data.teSoftCount.sumCount;
        resourceList[3].usedCount = res.data.te1080pHardCount.usedCount;
        resourceList[3].sumCount = res.data.te1080pHardCount.sumCount;
        resourceList[4].usedCount = res.data.te720pHardCount.usedCount;
        resourceList[4].sumCount = res.data.te720pHardCount.sumCount;
        resourceList[5].usedCount = res.data.thirdPartyHardCount.usedCount;
        resourceList[5].sumCount = res.data.thirdPartyHardCount.sumCount;
        // resourceList[6].usedCount = res.data.recordCapability.usedCount;
        // resourceList[6].sumCount = res.data.recordCapability.sumCount;

        this.setState({
          resourceList
        });
      }
    });
  }
  render() {
    return (
      <div>
        {/* <Tabs defaultActiveKey="1">
          <TabPane tab="资源管理" key="1"> */}
        <Alert
          message={
            <div style={{ color: "#333" }}>
              <span>使用云会议服务，请先购买资源，否则无法创建会议。</span>
            </div>
          }
          type="warning"
          showIcon
          style={{ marginBottom: "15px" }}
        />
        {/* <div style={{ marginBottom: "15px" }}>
          <Button
            onClick={() => {
              // this.props.history.push("/meeting/buy-resouce");
              this.props.history.push("/meeting/buy-setMeal");
            }}
            type="primary"
          >
            购买云会议软件套餐
        </Button>
          <a
            onClick={() => {
              // this.props.history.push("/meeting/buy-setMeal");
              this.props.history.push("/meeting/buy-resouce");
            }}
            type="primary"
            style={{ margin: '0 10px' }}
          >
            选配其他云会议资源
        </a>
        </div> */}
        <Row gutter={24} className="resource">
          {this.state.resourceList.map((item, index) => {
            return index !== 1 ? (
              <Col
                sm={{ span: 12 }}
                md={{ span: 8 }}
                xl={{ span: 6 }}
                key={index}
                className="item"
              >
                <div className="content">
                  <div>{item.title}</div>
                  <div>
                    <span className="green">{item.usedCount}</span>
                    {item.unit}/<span>{item.sumCount}</span>
                    {item.unit}
                  </div>
                </div>
              </Col>
            ) : this.state.resourceList[1].length > 0 ? (
              this.state.resourceList[1].map((list, i) => {
                return (
                  <Col
                    sm={{ span: 12 }}
                    md={{ span: 8 }}
                    xl={{ span: 6 }}
                    key={i}
                    className="item"
                  >
                    <div className="content">
                      <div>云会议室（{list.vmrName}）</div>
                      <div>
                        <span className="green">{list.vmrPkgUsedCount}</span>
                        个/<span>{list.vmrPkgCount}</span>个
                      </div>
                    </div>
                  </Col>
                );
              })
            ) : (
              <Col
                sm={{ span: 12 }}
                md={{ span: 8 }}
                xl={{ span: 6 }}
                key={index}
                className="item"
              >
                <div className="content">
                  <div>云会议室（运营VMR专用_25）</div>
                  <div>
                    <span className="green">0</span>
                    个/<span>0</span>个
                  </div>
                </div>
              </Col>
            );
          })}
        </Row>
        {/* </TabPane>
        </Tabs> */}
      </div>
    );
  }
}
