/**
 * 会议资源管理
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Alert, Row, Col, Tabs, Button } from "antd";
import PTable from "../../../components/Pro/PTable";
import { withRouter } from "dva/router";
import { formatCurrency } from '../../../utils/utils';
import "../meeting.less";
@Form.create()
@withRouter
export default class OrderInquiry extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      pageParm: {
        pageSize: 10,
        pageNumber: 1
      },
      forceUpdate: false
    };
  }
  componentDidMount() {
  }
  render() {
    const columns = [
      {
        title: "订单编号",
        dataIndex: "comOrderId",
        key: "comOrderId"
      },
      {
        title: "产品名称",
        dataIndex: "productCategory",
        key: "productCategory"
      },
      {
        title: "产品详情",
        dataIndex: "orderDetailList",
        key: "orderDetailList",
        width: 400,
        render: (text, record) => (
          <div>
            {text.map((item, index) => {
              return (
                <span style={{ display: 'inline-block' }} key={index}>
                  {item.productTypeName}（{item.productName}）{item.eachAmount}
                  {item.unit} 数量{item.num}个
                </span>
              );
            })}
          </div>
        )
      },
      {
        title: "总价（元）",
        dataIndex: "amount",
        key: "amount",
        render: (text, record) => {
          return <span>{text == 0 ? 0 : formatCurrency(text)}</span>
        }
      },
      {
        title: "实际支付金额（元）",
        dataIndex: "actualPayAmount",
        key: "actualPayAmount",
        render: (text, record) => {
          return <span>{text == 0 ? 0 : formatCurrency(text)}</span>
        }
      },
      {
        title: "支付时间",
        dataIndex: "createTime",
        key: "createTime"
      },
      {
        title: "订单状态",
        dataIndex: "orderStatus",
        key: "orderStatus"
      },
      {
        title: "订单配置状态",
        dataIndex: "orderDeployStatus",
        key: "orderDeployStatus"
      }
    ];
    return (
      <div >
        <Alert
          message={
            <div style={{ color: "#333" }}>
              <span>订单支付成功后，系统需要1~2个工作日完成资源配置。</span>
            </div>
          }
          type="warning"
          showIcon
          style={{ marginBottom: "15px" }}
        />
        <PTable
          style={{ marginTop: 20 }}
          columns={columns}
          url="getOrderList"
          pageParm={this.state.pageParm}
          forceUpdate={this.state.forceUpdate}
        />
      </div>
    );
  }
}
