import { saveInsBlbMinusPreservationByNotIncluded } from '../../../../../services/api';
import $modal from '../../../../../utils/modal';
import { notification } from 'antd';
export default function() {
  return [
    {
      title: '姓名',
      dataIndex: 'name',
      key: 'name',
    },
    {
      title: '身份证号',
      dataIndex: 'idCardNo',
      key: 'idCardNo',
    },
    {
      title: '关联保单号',
      dataIndex: 'policyNo',
      key: 'policyNo',
    },
    {
      title: '保单有效期',
      dataIndex: 'effectDate',
      key: 'effectDate',
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      render: (text, record) => {
        const { orderId, insPerDetailId, name } = record;
        const insPerDetailIds = insPerDetailId;
        return (
          <a onClick={() => {
            $modal(
              `是否对${name}进行减员操作`,
              <span>关联线下保单，则直接移除关联；<br/>关联线上保单，则提交减员申请。</span>,
              [
                {
                  text: '确定',
                  type: 'primary',
                  onPress: () => {
                    saveInsBlbMinusPreservationByNotIncluded({ insPerDetailIds, orderId }).then(res => {
                      $modal(
                        '提交减员申请成功！',
                        <span style={{color: 'orange'}}>注：线上保单减员时，需要等待保险公司审核，请在<a href="">批单申请记录</a>钟查看进度。</span>,
                        [{text: '确定', type: 'primary'}],
                        'success'
                      );
                      this._updateTable();
                    }).catch(err => {
                      if(err.retType == '-1') {
                        notification.error({
                          message: err.msg
                        });
                      }
                    });
                  }
                },
                {
                  text: '取消'
                }
              ]
            );
            
          }}>减员</a>
        );
      }
    }
  ];
}